/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.Roles;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractMutableVirtualTable;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;

final class RolesCacheKeysTable
extends AbstractMutableVirtualTable {
    private static final String ROLE = "role";

    RolesCacheKeysTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "roles_cache_keys").comment("keys in the roles cache").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(ROLE, (AbstractType)UTF8Type.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        Roles.cache.getAll().forEach((roleResource, ignored) -> result.row(roleResource.getRoleName()));
        return result;
    }

    @Override
    protected void applyPartitionDeletion(AbstractMutableVirtualTable.ColumnValues partitionKey) {
        RoleResource roleResource = RoleResource.role((String)partitionKey.value(0));
        Roles.cache.invalidate(roleResource);
    }

    @Override
    public void truncate() {
        Roles.cache.invalidate();
    }
}

