/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.TimeUUID;

public class StatusRequest
extends RepairMessage {
    public final TimeUUID sessionID;
    public static final IVersionedSerializer<StatusRequest> serializer = new IVersionedSerializer<StatusRequest>(){

        @Override
        public void serialize(StatusRequest msg, DataOutputPlus out, int version) throws IOException {
            msg.sessionID.serialize(out);
        }

        @Override
        public StatusRequest deserialize(DataInputPlus in, int version) throws IOException {
            return new StatusRequest(TimeUUID.deserialize(in));
        }

        @Override
        public long serializedSize(StatusRequest msg, int version) {
            return TimeUUID.sizeInBytes();
        }
    };

    public StatusRequest(TimeUUID sessionID) {
        super(null);
        this.sessionID = sessionID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusRequest request = (StatusRequest)o;
        return this.sessionID.equals(request.sessionID);
    }

    public int hashCode() {
        return this.sessionID.hashCode();
    }

    public String toString() {
        return "StatusRequest{sessionID=" + this.sessionID + '}';
    }
}

