/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.consistent.ConsistentSession;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.TimeUUID;

public class StatusResponse
extends RepairMessage {
    public final TimeUUID sessionID;
    public final ConsistentSession.State state;
    public static final IVersionedSerializer<StatusResponse> serializer = new IVersionedSerializer<StatusResponse>(){

        @Override
        public void serialize(StatusResponse msg, DataOutputPlus out, int version) throws IOException {
            msg.sessionID.serialize(out);
            out.writeInt(msg.state.ordinal());
        }

        @Override
        public StatusResponse deserialize(DataInputPlus in, int version) throws IOException {
            return new StatusResponse(TimeUUID.deserialize(in), ConsistentSession.State.valueOf(in.readInt()));
        }

        @Override
        public long serializedSize(StatusResponse msg, int version) {
            return TimeUUID.sizeInBytes() + (long)TypeSizes.sizeof(msg.state.ordinal());
        }
    };

    public StatusResponse(TimeUUID sessionID, ConsistentSession.State state) {
        super(null);
        assert (sessionID != null);
        assert (state != null);
        this.sessionID = sessionID;
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusResponse that = (StatusResponse)o;
        if (!this.sessionID.equals(that.sessionID)) {
            return false;
        }
        return this.state == that.state;
    }

    public int hashCode() {
        int result = this.sessionID.hashCode();
        result = 31 * result + this.state.hashCode();
        return result;
    }

    public String toString() {
        return "StatusResponse{sessionID=" + this.sessionID + ", state=" + (Object)((Object)this.state) + '}';
    }
}

