/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.concatfields;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.concatfields.ConcatField;
import org.apache.hop.pipeline.transforms.concatfields.ConcatFields;
import org.apache.hop.pipeline.transforms.concatfields.ConcatFieldsData;
import org.apache.hop.pipeline.transforms.concatfields.ExtraFields;

@Transform(id="ConcatFields", image="concatfields.svg", name="i18n::ConcatFields.Name", description="i18n::ConcatFields.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::ConcatFieldsMeta.keyword"}, documentationUrl="/pipeline/transforms/concatfields.html")
public class ConcatFieldsMeta
extends BaseTransformMeta<ConcatFields, ConcatFieldsData> {
    private static final Class<?> PKG = ConcatFieldsMeta.class;
    @HopMetadataProperty(key="separator", injectionKey="SEPARATOR")
    private String separator;
    @HopMetadataProperty(key="enclosure", injectionKey="ENCLOSURE")
    private String enclosure;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="OUTPUT_FIELDS")
    private List<ConcatField> outputFields = new ArrayList<ConcatField>();
    @HopMetadataProperty(key="ConcatFields")
    private ExtraFields extraFields = new ExtraFields();

    public ConcatFieldsMeta() {
    }

    public ConcatFieldsMeta(ConcatFieldsMeta m) {
        this();
        this.separator = m.separator;
        this.enclosure = m.enclosure;
        this.extraFields = new ExtraFields(m.extraFields);
        for (ConcatField field : this.outputFields) {
            this.outputFields.add(new ConcatField(field));
        }
    }

    public void setDefault() {
        this.separator = ";";
        this.enclosure = "\"";
        this.extraFields.setTargetFieldName("");
        this.extraFields.setTargetFieldLength(0);
        this.extraFields.setRemoveSelectedFields(false);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.extraFields.isRemoveSelectedFields()) {
            if (!this.getOutputFields().isEmpty()) {
                for (int i = 0; i < this.getOutputFields().size(); ++i) {
                    ConcatField field = this.getOutputFields().get(i);
                    try {
                        row.removeValueMeta(field.getName());
                        continue;
                    }
                    catch (HopValueException hopValueException) {
                        // empty catch block
                    }
                }
            } else {
                row.clear();
            }
        }
        if (StringUtil.isEmpty((String)this.extraFields.getTargetFieldName())) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.TargetFieldNameMissing", (String[])new String[0]));
        }
        ValueMetaString vValue = new ValueMetaString(this.extraFields.getTargetFieldName(), this.extraFields.getTargetFieldLength(), 0);
        vValue.setOrigin(name);
        row.addValueMeta((IValueMeta)vValue);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (StringUtil.isEmpty((String)this.extraFields.getTargetFieldName())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.TargetFieldNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.extraFields.getTargetFieldLength() <= 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.TargetFieldLengthMissingFastDataDump", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.getOutputFields().size(); ++i) {
                int idx = prev.indexOfValue(this.getOutputFields().get(i).getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.getOutputFields().get(i).getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public List<ConcatField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<ConcatField> outputFields) {
        this.outputFields = outputFields;
    }

    public ExtraFields getExtraFields() {
        return this.extraFields;
    }

    public void setExtraFields(ExtraFields extraFields) {
        this.extraFields = extraFields;
    }
}

