/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.WidgetUtils;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class TopicSelection
extends Composite {
    private final PropsUi props;
    private final IVariables variables;
    private final BaseTransformMeta transformMeta;
    private final ModifyListener lsMod;
    private final boolean topicInField;
    private final String topicGroupLabel;
    private final String fieldTopicLabel;
    private final String textTopicLabel;
    private final String textTopicRadioLabel;
    private final String fieldTopicRadioLabel;
    private Group wTopicGroup;
    private Button wTopicFromField;
    private Button wTopicFromText;
    private Label wlTopic;
    private TextVar wTopicText;
    private ComboVar wTopicField;

    private TopicSelection(Builder builder) {
        super(builder.composite, builder.style);
        this.props = builder.props;
        this.variables = builder.variables;
        this.transformMeta = builder.transformMeta;
        this.lsMod = builder.lsMod;
        this.topicInField = builder.topicInField;
        this.topicGroupLabel = builder.topicGroupLabel;
        this.fieldTopicLabel = builder.fieldTopicLabel;
        this.textTopicLabel = builder.textTopicLabel;
        this.textTopicRadioLabel = builder.textTopicRadioLabel;
        this.fieldTopicRadioLabel = builder.fieldTopicRadioLabel;
        this.layoutUI();
    }

    private void layoutUI() {
        FormLayout topicSelectionLayout = new FormLayout();
        this.setLayout((Layout)topicSelectionLayout);
        this.wTopicGroup = new Group((Composite)this, 16);
        PropsUi.setLook((Widget)this.wTopicGroup);
        this.wTopicGroup.setText(this.topicGroupLabel);
        FormLayout topicGroupLayout = new FormLayout();
        topicGroupLayout.marginHeight = 15;
        topicGroupLayout.marginWidth = 15;
        this.wTopicGroup.setLayout((Layout)topicGroupLayout);
        FormData fdTopicGroup = new FormData();
        fdTopicGroup.left = new FormAttachment(0, 0);
        fdTopicGroup.top = new FormAttachment(0, 10);
        fdTopicGroup.right = new FormAttachment(100, 0);
        fdTopicGroup.bottom = new FormAttachment(100, 0);
        this.wTopicGroup.setLayoutData((Object)fdTopicGroup);
        this.wTopicFromText = new Button((Composite)this.wTopicGroup, 16);
        this.wTopicFromField = new Button((Composite)this.wTopicGroup, 16);
        PropsUi.setLook((Widget)this.wTopicFromText);
        PropsUi.setLook((Widget)this.wTopicFromField);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                TopicSelection.this.setTopicWidgetVisibility(TopicSelection.this.wTopicFromField);
            }
        };
        this.wTopicFromField.addSelectionListener((SelectionListener)selectionListener);
        this.wTopicFromText.addSelectionListener((SelectionListener)selectionListener);
        this.wTopicFromField.setSelection(this.topicInField);
        this.wTopicFromText.setSelection(!this.topicInField);
        this.wTopicFromText.setText(this.textTopicRadioLabel);
        this.wTopicFromField.setText(this.fieldTopicRadioLabel);
        FormData specifyTopicLayout = new FormData();
        specifyTopicLayout.left = new FormAttachment(0, 0);
        specifyTopicLayout.top = new FormAttachment(0, 0);
        this.wTopicFromText.setLayoutData((Object)specifyTopicLayout);
        FormData fdTopicComesFromField = new FormData();
        fdTopicComesFromField.left = new FormAttachment(0, 0);
        fdTopicComesFromField.top = new FormAttachment((Control)this.wTopicFromText, 5);
        this.wTopicFromField.setLayoutData((Object)fdTopicComesFromField);
        this.wTopicFromField.addSelectionListener((SelectionListener)selectionListener);
        this.wTopicFromText.addSelectionListener((SelectionListener)selectionListener);
        Label separator = new Label((Composite)this.wTopicGroup, 514);
        FormData fdSeparator = new FormData();
        fdSeparator.top = new FormAttachment(0, 0);
        fdSeparator.left = new FormAttachment((Control)this.wTopicFromField, 15);
        fdSeparator.bottom = new FormAttachment(100, 0);
        separator.setLayoutData((Object)fdSeparator);
        FormData fdTopicEntry = new FormData();
        fdTopicEntry.top = new FormAttachment(0, 0);
        fdTopicEntry.left = new FormAttachment((Control)separator, 15);
        fdTopicEntry.right = new FormAttachment(100, 0);
        this.wlTopic = new Label((Composite)this.wTopicGroup, 16384);
        this.wlTopic.setLayoutData((Object)fdTopicEntry);
        PropsUi.setLook((Widget)this.wlTopic);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.wlTopic, 5);
        formData.left = new FormAttachment((Control)separator, 15);
        formData.right = new FormAttachment(100, 0);
        this.wTopicText = new TextVar(this.variables, (Composite)this.wTopicGroup, 18436);
        this.wTopicField = WidgetUtils.createFieldDropDown((Composite)this.wTopicGroup, this.props, this.variables, this.transformMeta, formData);
        this.wTopicText.setLayoutData(formData);
        this.wTopicField.setLayoutData(formData);
        this.setTopicWidgetVisibility(this.wTopicFromField);
        this.wTopicText.addModifyListener(this.lsMod);
        this.wTopicField.addModifyListener(this.lsMod);
    }

    private void setTopicWidgetVisibility(Button topicComesFromField) {
        this.transformMeta.setChanged(this.transformMeta.hasChanged() || this.topicInField != topicComesFromField.getSelection());
        this.wTopicField.setVisible(topicComesFromField.getSelection());
        this.wTopicText.setVisible(!topicComesFromField.getSelection());
        if (topicComesFromField.getSelection()) {
            this.wlTopic.setText(this.fieldTopicLabel);
        } else {
            this.wlTopic.setText(this.textTopicLabel);
        }
    }

    public String getTopicText() {
        return this.wTopicText.getText();
    }

    public String getTopicFieldText() {
        return this.wTopicField.getText();
    }

    public void setTopicFieldText(String selectedTopicFieldText) {
        this.wTopicField.setText(selectedTopicFieldText);
    }

    public void setTopicText(String topicText) {
        this.wTopicText.setText(topicText);
    }

    public void setTopicInField(boolean topicInField) {
        this.wTopicFromField.setSelection(topicInField);
        this.wTopicFromText.setSelection(!topicInField);
        this.setTopicWidgetVisibility(this.wTopicFromField);
    }

    public boolean isTopicInField() {
        return this.wTopicFromField.getSelection();
    }

    public void setEnabled(boolean enabled) {
        this.wTopicGroup.setEnabled(enabled);
        this.wTopicFromField.setEnabled(enabled);
        this.wTopicFromText.setEnabled(enabled);
        this.wlTopic.setEnabled(enabled);
        this.wTopicText.setEnabled(enabled);
        this.wTopicText.setEditable(enabled);
        this.wTopicField.setEnabled(enabled);
        this.wTopicField.setEditable(enabled);
    }

    public static final class Builder {
        private Composite composite;
        private int style;
        private PropsUi props;
        private IVariables variables;
        private BaseTransformMeta transformMeta;
        private ModifyListener lsMod;
        private boolean topicInField;
        private String topicGroupLabel;
        private String fieldTopicLabel;
        private String textTopicLabel;
        private String textTopicRadioLabel;
        private String fieldTopicRadioLabel;

        public Builder setComposite(Composite composite) {
            this.composite = composite;
            return this;
        }

        public Builder setStyle(int style) {
            this.style = style;
            return this;
        }

        public Builder setProps(PropsUi props) {
            this.props = props;
            return this;
        }

        public Builder setVariables(IVariables variables) {
            this.variables = variables;
            return this;
        }

        public Builder setTransformMeta(BaseTransformMeta transformMeta) {
            this.transformMeta = transformMeta;
            return this;
        }

        public Builder setLsMod(ModifyListener lsMod) {
            this.lsMod = lsMod;
            return this;
        }

        public Builder setTopicInField(boolean topicInField) {
            this.topicInField = topicInField;
            return this;
        }

        public Builder setTopicGroupLabel(String topicGroupLabel) {
            this.topicGroupLabel = topicGroupLabel;
            return this;
        }

        public Builder setFieldTopicLabel(String fieldTopicLabel) {
            this.fieldTopicLabel = fieldTopicLabel;
            return this;
        }

        public Builder setTextTopicLabel(String textTopicLabel) {
            this.textTopicLabel = textTopicLabel;
            return this;
        }

        public Builder setTextTopicRadioLabel(String textTopicRadioLabel) {
            this.textTopicRadioLabel = textTopicRadioLabel;
            return this;
        }

        public Builder setFieldTopicRadioLabel(String fieldTopicRadioLabel) {
            this.fieldTopicRadioLabel = fieldTopicRadioLabel;
            return this;
        }

        public TopicSelection build() {
            return new TopicSelection(this);
        }
    }
}

