/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.delegates;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiLogBrowser;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="Pipeline Graph Log Delegate")
public class HopGuiPipelineLogDelegate {
    private static final Class<?> PKG = HopGui.class;
    private static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "HopGuiPipelineLogDelegate-ToolBar";
    public static final String TOOLBAR_ICON_CLEAR_LOG_VIEW = "ToolbarIcon-10000-ClearLog";
    public static final String TOOLBAR_ICON_SHOW_ERROR_LINES = "ToolbarIcon-10010-ShowErrorLines";
    public static final String TOOLBAR_ICON_LOG_COPY_TO_CLIPBOARD = "ToolbarIcon-10020-LogCopyToClipboard";
    public static final String TOOLBAR_ICON_LOG_PAUSE_RESUME = "ToolbarIcon-10030-LogPauseResume";
    private HopGuiPipelineGraph pipelineGraph;
    private HopGui hopGui;
    private CTabItem pipelineLogTab;
    private Text pipelineLogText;
    private ToolBar toolbar;
    private GuiToolbarWidgets toolBarWidgets;
    private Composite pipelineLogComposite;
    private HopGuiLogBrowser logBrowser;

    public HopGuiPipelineLogDelegate(HopGui hopGui, HopGuiPipelineGraph pipelineGraph) {
        this.hopGui = hopGui;
        this.pipelineGraph = pipelineGraph;
    }

    public void addPipelineLog() {
        if (this.pipelineGraph.extraViewTabFolder == null || this.pipelineGraph.extraViewTabFolder.isDisposed()) {
            this.pipelineGraph.addExtraView();
        } else if (this.pipelineLogTab != null && !this.pipelineLogTab.isDisposed()) {
            this.pipelineGraph.extraViewTabFolder.setSelection(this.pipelineLogTab);
            return;
        }
        this.pipelineLogTab = new CTabItem(this.pipelineGraph.extraViewTabFolder, 0);
        this.pipelineLogTab.setFont(GuiResource.getInstance().getFontDefault());
        this.pipelineLogTab.setImage(GuiResource.getInstance().getImageShowLog());
        this.pipelineLogTab.setText(BaseMessages.getString(PKG, (String)"HopGui.PipelineGraph.LogTab.Name", (String[])new String[0]));
        this.pipelineLogComposite = new Composite((Composite)this.pipelineGraph.extraViewTabFolder, 786432);
        this.pipelineLogComposite.setLayout((Layout)new FormLayout());
        this.addToolBar();
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.toolbar.setLayoutData((Object)fd);
        this.pipelineLogText = new Text(this.pipelineLogComposite, 2826);
        PropsUi.setLook((Widget)this.pipelineLogText);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment((Control)this.toolbar, 0);
        fdText.bottom = new FormAttachment(100, 0);
        this.pipelineLogText.setLayoutData((Object)fdText);
        if (OsHelper.isMac()) {
            this.pipelineLogText.setText(Const.CR);
        }
        this.logBrowser = new HopGuiLogBrowser(this.pipelineLogText, this.pipelineGraph);
        this.logBrowser.installLogSniffer();
        this.pipelineGraph.addDisposeListener(event -> {
            if (this.pipelineGraph.pipeline != null) {
                HopLogStore.discardLines((String)this.pipelineGraph.pipeline.getLogChannelId(), (boolean)true);
            }
        });
        this.pipelineLogTab.setControl((Control)this.pipelineLogComposite);
        this.pipelineGraph.extraViewTabFolder.setSelection(this.pipelineLogTab);
    }

    public static HopGuiPipelineLogDelegate getInstance() {
        IHopFileTypeHandler fileTypeHandler = HopGui.getInstance().getActiveFileTypeHandler();
        if (fileTypeHandler instanceof HopGuiPipelineGraph) {
            HopGuiPipelineGraph graph = (HopGuiPipelineGraph)fileTypeHandler;
            return graph.pipelineLogDelegate;
        }
        return null;
    }

    private void addToolBar() {
        this.toolbar = new ToolBar(this.pipelineLogComposite, 16704);
        FormData fdToolBar = new FormData();
        fdToolBar.left = new FormAttachment(0, 0);
        fdToolBar.top = new FormAttachment(0, 0);
        fdToolBar.right = new FormAttachment(100, 0);
        this.toolbar.setLayoutData((Object)fdToolBar);
        PropsUi.setLook((Widget)this.toolbar, 5);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)this.toolbar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        this.toolbar.pack();
    }

    public void showLogView() {
        if (this.pipelineLogTab == null || this.pipelineLogTab.isDisposed()) {
            this.addPipelineLog();
        } else {
            this.pipelineLogTab.dispose();
            this.pipelineGraph.checkEmptyExtraView();
        }
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10000-ClearLog", toolTip="i18n:org.apache.hop.ui.hopgui:PipelineLog.Button.ClearLog", image="ui/images/delete.svg")
    public void clearLog() {
        Map<String, String> transformLogMap;
        if (this.pipelineLogText != null && !this.pipelineLogText.isDisposed()) {
            if (OsHelper.isMac()) {
                this.pipelineLogText.setText(Const.CR);
            } else {
                this.pipelineLogText.setText("");
            }
        }
        if ((transformLogMap = this.pipelineGraph.getTransformLogMap()) != null) {
            transformLogMap.clear();
            this.pipelineGraph.getDisplay().asyncExec(() -> this.pipelineGraph.redraw());
        }
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10020-LogCopyToClipboard", toolTip="i18n:org.apache.hop.ui.hopgui:PipelineLog.Button.LogCopyToClipboard", image="ui/images/copy.svg")
    public void copyToClipboard() {
        GuiResource.getInstance().toClipboard(this.pipelineLogText.getText());
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10010-ShowErrorLines", toolTip="i18n:org.apache.hop.ui.hopgui:PipelineLog.Button.ShowErrorLines", image="ui/images/filter.svg")
    public void showErrors() {
        String uLine;
        String line;
        int i;
        String all = this.pipelineLogText.getText();
        ArrayList<String> err = new ArrayList<String>();
        int startpos = 0;
        int crlen = Const.CR.length();
        for (i = 0; i < all.length() - crlen; ++i) {
            if (!all.substring(i, i + crlen).equalsIgnoreCase(Const.CR)) continue;
            line = all.substring(startpos, i);
            uLine = line.toUpperCase();
            if (uLine.indexOf(BaseMessages.getString(PKG, (String)"PipelineLog.System.ERROR", (String[])new String[0])) >= 0 || uLine.indexOf(BaseMessages.getString(PKG, (String)"PipelineLog.System.EXCEPTION", (String[])new String[0])) >= 0 || uLine.indexOf("ERROR") >= 0 || uLine.indexOf("EXCEPTION") >= 0) {
                err.add(line);
            }
            startpos = i + crlen;
        }
        line = all.substring(startpos);
        uLine = line.toUpperCase();
        if (uLine.indexOf(BaseMessages.getString(PKG, (String)"PipelineLog.System.ERROR2", (String[])new String[0])) >= 0 || uLine.indexOf(BaseMessages.getString(PKG, (String)"PipelineLog.System.EXCEPTION2", (String[])new String[0])) >= 0 || uLine.indexOf("ERROR") >= 0 || uLine.indexOf("EXCEPTION") >= 0) {
            err.add(line);
        }
        if (err.size() > 0) {
            String[] errLines = new String[err.size()];
            for (i = 0; i < errLines.length; ++i) {
                errLines[i] = (String)err.get(i);
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.pipelineGraph.getShell(), errLines, BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.ErrorLines.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineLog.Dialog.ErrorLines.Message", (String[])new String[0]));
            line = esd.open();
            if (line != null) {
                PipelineMeta pipelineMeta = this.pipelineGraph.getManagedObject();
                for (i = 0; i < pipelineMeta.nrTransforms(); ++i) {
                    TransformMeta transformMeta = pipelineMeta.getTransform(i);
                    if (line.indexOf(transformMeta.getName()) < 0) continue;
                    this.pipelineGraph.editTransform(pipelineMeta, transformMeta);
                }
            }
        }
    }

    public CTabItem getPipelineLogTab() {
        return this.pipelineLogTab;
    }

    public String getLoggingText() {
        if (this.pipelineLogText != null && !this.pipelineLogText.isDisposed()) {
            return this.pipelineLogText.getText();
        }
        return null;
    }

    @GuiToolbarElement(root="HopGuiPipelineLogDelegate-ToolBar", id="ToolbarIcon-10030-LogPauseResume", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.Pause", image="ui/images/pause.svg", separator=true)
    public void pauseLog() {
        ToolItem item = this.toolBarWidgets.findToolItem(TOOLBAR_ICON_LOG_PAUSE_RESUME);
        if (this.logBrowser.isPaused()) {
            this.logBrowser.setPaused(false);
            item.setImage(GuiResource.getInstance().getImageRun());
        } else {
            this.logBrowser.setPaused(true);
            item.setImage(GuiResource.getInstance().getImagePause());
        }
    }

    public HopGuiLogBrowser getLogBrowser() {
        return this.logBrowser;
    }

    public boolean hasSelectedText() {
        return this.pipelineLogText != null && !this.pipelineLogText.isDisposed() && StringUtils.isNotEmpty((String)this.pipelineLogText.getSelectionText());
    }

    public void copySelected() {
        if (this.hasSelectedText()) {
            this.pipelineGraph.pipelineClipboardDelegate.toClipboard(this.pipelineLogText.getSelectionText());
        }
    }
}

