/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.runners.flink.FlinkJobInvoker;
import org.apache.beam.runners.flink.FlinkJobServerDriver;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPortableRunnerResult;
import org.apache.beam.runners.fnexecution.environment.ProcessManager;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.jobsubmission.JobInvocation;
import org.apache.beam.runners.jobsubmission.JobInvoker;
import org.apache.beam.runners.jobsubmission.JobServerDriver;
import org.apache.beam.runners.jobsubmission.PortablePipelineResult;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.flink.api.common.time.Deadline;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkPortableClientEntryPoint {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkPortableClientEntryPoint.class);
    private static final @UnknownKeyFor @NonNull @Initialized String JOB_ENDPOINT_FLAG = "--job_endpoint";
    private static final @UnknownKeyFor @NonNull @Initialized Duration JOB_INVOCATION_TIMEOUT = Duration.ofSeconds(30L);
    private static final @UnknownKeyFor @NonNull @Initialized Duration JOB_SERVICE_STARTUP_TIMEOUT = Duration.ofSeconds(30L);
    private final @UnknownKeyFor @NonNull @Initialized String driverCmd;
    private @UnknownKeyFor @NonNull @Initialized FlinkJobServerDriver jobServer;
    private @UnknownKeyFor @NonNull @Initialized Thread jobServerThread;
    private @UnknownKeyFor @NonNull @Initialized FlinkPortableClientEntryPoint. @UnknownKeyFor @NonNull @Initialized DetachedJobInvokerFactory jobInvokerFactory;
    private @UnknownKeyFor @NonNull @Initialized int jobPort = 0;

    public FlinkPortableClientEntryPoint(@UnknownKeyFor @NonNull @Initialized String driverCmd) {
        Preconditions.checkState((!driverCmd.contains(JOB_ENDPOINT_FLAG) ? 1 : 0) != 0, (Object)"Driver command must not contain --job_endpoint");
        this.driverCmd = driverCmd;
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized Exception {
        LOG.info("entry points args: {}", Arrays.asList(args));
        EntryPointConfiguration configuration = FlinkPortableClientEntryPoint.parseArgs(args);
        FlinkPortableClientEntryPoint runner = new FlinkPortableClientEntryPoint(configuration.driverCmd);
        try {
            runner.startJobService();
            runner.runDriverProgram();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Job %s failed.", configuration.driverCmd), e);
        }
        finally {
            LOG.info("Stopping job service");
            runner.stopJobService();
        }
        LOG.info("Job submitted successfully.");
    }

    private static @UnknownKeyFor @NonNull @Initialized EntryPointConfiguration parseArgs(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        EntryPointConfiguration configuration = new EntryPointConfiguration();
        CmdLineParser parser = new CmdLineParser((Object)configuration);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            LOG.error("Unable to parse command line arguments.", (Throwable)e);
            parser.printUsage((OutputStream)System.err);
            throw new IllegalArgumentException("Unable to parse command line arguments.", e);
        }
        return configuration;
    }

    private void startJobService() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.jobInvokerFactory = new DetachedJobInvokerFactory();
        this.jobServer = FlinkJobServerDriver.fromConfig(FlinkJobServerDriver.parseArgs(new String[]{"--job-port=" + this.jobPort, "--artifact-port=0", "--expansion-port=0"}), this.jobInvokerFactory);
        this.jobServerThread = new Thread((Runnable)((Object)this.jobServer));
        this.jobServerThread.start();
        Deadline deadline = Deadline.fromNow((Duration)JOB_SERVICE_STARTUP_TIMEOUT);
        while (this.jobServer.getJobServerUrl() == null && deadline.hasTimeLeft()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptEx) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(interruptEx);
            }
        }
        if (!this.jobServerThread.isAlive()) {
            throw new IllegalStateException("Job service thread is not alive");
        }
        if (this.jobServer.getJobServerUrl() == null) {
            String msg = String.format("Timeout of %s waiting for job service to start.", deadline);
            throw new TimeoutException(msg);
        }
    }

    private void runDriverProgram() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ProcessManager processManager = ProcessManager.create();
        String executable = "bash";
        ImmutableList args = ImmutableList.of((Object)"-c", (Object)String.format("%s %s=%s", this.driverCmd, JOB_ENDPOINT_FLAG, this.jobServer.getJobServerUrl()));
        String processId = "client1";
        File outputFile = File.createTempFile("beam-driver-program", ".log");
        try {
            ProcessManager.RunningProcess driverProcess = processManager.startProcess(processId, executable, (List)args, System.getenv(), outputFile);
            driverProcess.isAliveOrThrow();
            LOG.info("Started driver program");
            this.jobInvokerFactory.executeDetachedJob();
        }
        catch (Exception e) {
            try {
                processManager.stopProcess(processId);
            }
            catch (Exception processKillException) {
                e.addSuppressed(processKillException);
            }
            byte[] output = Files.readAllBytes(outputFile.toPath());
            String msg = String.format("Failed to start job with driver program: %s %s output: %s", executable, args, new String(output, StandardCharsets.UTF_8));
            throw new RuntimeException(msg, e);
        }
    }

    private void stopJobService() throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        if (this.jobServer != null) {
            this.jobServer.stop();
        }
        if (this.jobServerThread != null) {
            this.jobServerThread.interrupt();
            this.jobServerThread.join();
        }
    }

    private class DetachedJobInvokerFactory
    implements JobServerDriver.JobInvokerFactory {
        private @UnknownKeyFor @NonNull @Initialized CountDownLatch latch = new CountDownLatch(1);
        private volatile @UnknownKeyFor @NonNull @Initialized PortablePipelineRunner actualPipelineRunner;
        private volatile // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline;
        private volatile @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo;
        private @UnknownKeyFor @NonNull @Initialized PortablePipelineRunner handoverPipelineRunner = new PortablePipelineRunner(){

            public @UnknownKeyFor @NonNull @Initialized PortablePipelineResult run(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
                DetachedJobInvokerFactory.this.pipeline = pipeline;
                DetachedJobInvokerFactory.this.jobInfo = jobInfo;
                LOG.info("Pipeline execution handover for {}", (Object)jobInfo.jobId());
                DetachedJobInvokerFactory.this.latch.countDown();
                return new FlinkPortableRunnerResult.Detached();
            }
        };

        private DetachedJobInvokerFactory() {
        }

        public @UnknownKeyFor @NonNull @Initialized JobInvoker create() {
            return new FlinkJobInvoker((FlinkJobServerDriver.FlinkServerConfiguration)((FlinkPortableClientEntryPoint)FlinkPortableClientEntryPoint.this).jobServer.configuration){

                @Override
                protected @UnknownKeyFor @NonNull @Initialized JobInvocation createJobInvocation(@UnknownKeyFor @NonNull @Initialized String invocationId, @UnknownKeyFor @NonNull @Initialized String retrievalToken, @UnknownKeyFor @NonNull @Initialized ListeningExecutorService executorService, // Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions flinkOptions, @UnknownKeyFor @NonNull @Initialized PortablePipelineRunner pipelineRunner) {
                    DetachedJobInvokerFactory.this.actualPipelineRunner = pipelineRunner;
                    return super.createJobInvocation(invocationId, retrievalToken, executorService, pipeline, flinkOptions, DetachedJobInvokerFactory.this.handoverPipelineRunner);
                }
            };
        }

        private void executeDetachedJob() throws @UnknownKeyFor @NonNull @Initialized Exception {
            long timeoutSeconds = JOB_INVOCATION_TIMEOUT.getSeconds();
            if (!this.latch.await(timeoutSeconds, TimeUnit.SECONDS)) {
                throw new TimeoutException(String.format("Timeout of %s seconds waiting for job submission.", timeoutSeconds));
            }
            this.actualPipelineRunner.run(this.pipeline, this.jobInfo);
        }
    }

    private static class EntryPointConfiguration {
        @Option(name="--driver-cmd", required=true, usage="Command that launches the Python driver program. (The job service endpoint will be appended as --job_endpoint=localhost:<port>.)")
        private @UnknownKeyFor @NonNull @Initialized String driverCmd;

        private EntryPointConfiguration() {
        }
    }
}

