/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.flink.translation.functions.SideInputInitializer;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FlinkSideInputReader
implements SideInputReader {
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> SUPPORTED_MATERIALIZATIONS = ImmutableSet.of((Object)"beam:side_input:iterable:v1", (Object)"beam:side_input:multimap:v1");
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> sideInputs;
    private @UnknownKeyFor @NonNull @Initialized RuntimeContext runtimeContext;

    public FlinkSideInputReader(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> indexByView, @UnknownKeyFor @NonNull @Initialized RuntimeContext runtimeContext) {
        for (PCollectionView<?> pCollectionView : indexByView.keySet()) {
            Preconditions.checkArgument((boolean)SUPPORTED_MATERIALIZATIONS.contains(pCollectionView.getViewFn().getMaterialization().getUrn()), (String)"This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", SUPPORTED_MATERIALIZATIONS, (Object)pCollectionView.getViewFn().getMaterialization().getUrn(), (Object)pCollectionView.getTagInternal().getId());
        }
        this.sideInputs = new HashMap();
        for (Map.Entry entry : indexByView.entrySet()) {
            this.sideInputs.put(((PCollectionView)entry.getKey()).getTagInternal(), (WindowingStrategy)entry.getValue());
        }
        this.runtimeContext = runtimeContext;
    }

    public <T> @Nullable T get(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Preconditions.checkNotNull(view, (Object)"View passed to sideInput cannot be null");
        TupleTag tag = view.getTagInternal();
        Preconditions.checkNotNull(this.sideInputs.get(tag), (Object)("Side input for " + view + " not available."));
        Map sideInputs = (Map)this.runtimeContext.getBroadcastVariableWithInitializer(tag.getId(), new SideInputInitializer<T>(view));
        Object result = sideInputs.get(window);
        if (result == null) {
            switch (view.getViewFn().getMaterialization().getUrn()) {
                case "beam:side_input:iterable:v1": {
                    ViewFn viewFn = view.getViewFn();
                    return (T)viewFn.apply(() -> Collections.emptyList());
                }
                case "beam:side_input:multimap:v1": {
                    ViewFn viewFn = view.getViewFn();
                    return (T)viewFn.apply((Object)InMemoryMultimapSideInputView.empty());
                }
            }
            throw new IllegalStateException(String.format("Unknown side input materialization format requested '%s'", view.getViewFn().getMaterialization().getUrn()));
        }
        return (T)result;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.sideInputs.isEmpty();
    }
}

