/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.impulse;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class BeamImpulseSource
extends BoundedSource<byte[]> {
    public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return Collections.singletonList(this);
    }

    public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return 0L;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new ImpulseReader(this);
    }

    private static class ImpulseReader
    extends BoundedSource.BoundedReader<byte[]> {
        private final @UnknownKeyFor @NonNull @Initialized BeamImpulseSource source;
        private @UnknownKeyFor @NonNull @Initialized boolean started;
        private @UnknownKeyFor @NonNull @Initialized int index;

        private ImpulseReader(@UnknownKeyFor @NonNull @Initialized BeamImpulseSource source) {
            this.source = source;
            this.started = false;
            this.index = 0;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.started = true;
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (!this.started) {
                throw new IllegalStateException("start() should be called before calling advance()");
            }
            ++this.index;
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (!this.started) {
                throw new IllegalStateException("The reader hasn't started.");
            }
            if (this.index == 0) {
                return new byte[0];
            }
            throw new NoSuchElementException("No element is available.");
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getCurrentSource() {
            return this.source;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (!this.started) {
                throw new IllegalStateException("The reader hasn't started.");
            }
            if (this.index == 0) {
                return BoundedWindow.TIMESTAMP_MIN_VALUE;
            }
            throw new NoSuchElementException("No element is available.");
        }

        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        }
    }
}

