/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public abstract class XSLVariableDeclaration
extends XSLGeneralVariable
implements VariableDeclaration,
StylesheetProcedure {
    private int slotNumber = -9876;
    protected List references = new ArrayList(10);

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int n) {
        this.slotNumber = n;
    }

    public abstract SequenceType getRequiredType();

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public List getReferences() {
        return this.references;
    }

    public boolean isInstruction() {
        return true;
    }

    public List getReferenceList() {
        return this.references;
    }

    public void fixupReferences() throws XPathException {
        SequenceType sequenceType = this.getRequiredType();
        TypeHierarchy typeHierarchy = this.getNamePool().getTypeHierarchy();
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            Value value = null;
            int n = 0;
            if (this instanceof XSLVariable && !this.isAssignable()) {
                int n2;
                if (this.select instanceof Value && ((n2 = typeHierarchy.relationship(this.select.getItemType(typeHierarchy), sequenceType.getPrimaryType())) == 0 || n2 == 2)) {
                    value = (Value)this.select;
                }
                if (this.select != null) {
                    n = this.select.getSpecialProperties();
                }
            }
            ((BindingReference)iterator.next()).setStaticType(sequenceType, value, n);
        }
        super.fixupReferences();
    }

    public void validate() throws XPathException {
        super.validate();
        if (this.global) {
            if (!this.redundant) {
                this.slotNumber = this.getPrincipalStylesheet().allocateGlobalSlot(this.getVariableFingerprint());
            }
        } else {
            this.checkWithinTemplate();
        }
    }

    protected void fixupBinding(Binding binding) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            ((BindingReference)iterator.next()).fixup(binding);
        }
    }

    protected void setReferenceCount(GeneralVariable generalVariable) {
        int n = RangeVariableDeclaration.getReferenceCount(this.references, generalVariable, this.getStaticContext(), false);
        if (n < 10) {
            n = 10;
        }
        generalVariable.setReferenceCount(n);
    }
}

