/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Comparator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public class UntypedAtomicValue
extends StringValue {
    public static final UntypedAtomicValue ZERO_LENGTH_UNTYPED = new UntypedAtomicValue("");
    DoubleValue doubleValue = null;

    public UntypedAtomicValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.UNTYPED_ATOMIC_TYPE;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        int n = builtInAtomicType.getFingerprint();
        if (n == 513) {
            if (this.value.length() == 0) {
                return StringValue.EMPTY_STRING;
            }
            return new StringValue(this.value);
        }
        if (n == 517 || n == 646) {
            if (this.doubleValue == null) {
                AtomicValue atomicValue = super.convertPrimitive(builtInAtomicType, bl, xPathContext);
                if (atomicValue instanceof DoubleValue) {
                    this.doubleValue = (DoubleValue)atomicValue;
                }
                return atomicValue;
            }
            return this.doubleValue;
        }
        return super.convertPrimitive(builtInAtomicType, bl, xPathContext);
    }

    public int compareTo(Object object, Comparator comparator, XPathContext xPathContext) {
        if (object instanceof NumericValue) {
            if (this.doubleValue == null) {
                try {
                    this.doubleValue = (DoubleValue)this.convert(517, xPathContext);
                }
                catch (XPathException xPathException) {
                    throw new ClassCastException("Cannot convert untyped value \"" + this.getStringValueCS() + "\" to a double");
                }
            }
            return this.doubleValue.compareTo(object);
        }
        if (object instanceof StringValue) {
            if (comparator instanceof CodepointCollator) {
                return ((CodepointCollator)comparator).compareCS(this.getStringValueCS(), ((StringValue)object).getStringValueCS());
            }
            return comparator.compare(this.getStringValue(), ((StringValue)object).getStringValue());
        }
        if (object instanceof AtomicValue) {
            TypeHierarchy typeHierarchy = xPathContext.getNamePool().getTypeHierarchy();
            AtomicValue atomicValue = this.convert((AtomicType)((Value)object).getItemType(typeHierarchy), xPathContext, true);
            if (atomicValue instanceof ValidationErrorValue) {
                throw new ClassCastException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to type " + ((Value)object).getItemType(typeHierarchy));
            }
            if (!(atomicValue instanceof Comparable)) {
                throw new ClassCastException("Type " + ((Value)object).getItemType(typeHierarchy) + " is not ordered");
            }
            return ((Comparable)((Object)atomicValue)).compareTo(object);
        }
        return comparator.compare(this.getStringValue(), object.toString());
    }

    public boolean schemaEquals(Value value) {
        throw new UnsupportedOperationException("schemaEquals() cannot be applied to untyped atomic values");
    }
}

