/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.strings;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Latin1StringsParser
extends AbstractParser {
    private static final long serialVersionUID = 1L;
    private static final Set<MediaType> SUPPORTED_TYPES = Latin1StringsParser.getTypes();
    private static final boolean[] isChar = Latin1StringsParser.getCharMap();
    private static int BUF_SIZE = 65536;
    private int minSize = 4;
    private byte[] output = new byte[BUF_SIZE];
    private byte[] input = new byte[BUF_SIZE];
    private int tmpPos = 0;
    private int outPos = 0;
    private int inSize = 0;
    private int inPos = 0;
    private XHTMLContentHandler xhtml;

    private static boolean[] getCharMap() {
        boolean[] isChar = new boolean[256];
        for (int c = -128; c <= 127; ++c) {
            if (!(c >= 32 && c <= 126 || c >= -64 && c <= -2 || c == 10 || c == 13) && c != 9) continue;
            isChar[c & 0xFF] = true;
        }
        return isChar;
    }

    private static Set<MediaType> getTypes() {
        HashSet<MediaType> supportedTypes = new HashSet<MediaType>();
        supportedTypes.add(MediaType.OCTET_STREAM);
        return supportedTypes;
    }

    private static final boolean isChar(byte c) {
        return isChar[c & 0xFF];
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    private void flushBuffer() throws UnsupportedEncodingException, SAXException {
        if (this.tmpPos - this.outPos >= this.minSize) {
            this.outPos = this.tmpPos - this.minSize;
        }
        this.xhtml.characters(new String(this.output, 0, this.outPos, "windows-1252"));
        if (this.tmpPos - this.outPos >= 0) {
            System.arraycopy(this.output, this.outPos, this.output, 0, this.tmpPos - this.outPos);
        }
        this.tmpPos -= this.outPos;
        this.outPos = 0;
    }

    public Set<MediaType> getSupportedTypes(ParseContext arg0) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException {
        new Latin1StringsParser().doParse(stream, handler, metadata, context);
    }

    private void doParse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException {
        this.tmpPos = 0;
        this.outPos = 0;
        this.xhtml = new XHTMLContentHandler(handler, metadata);
        this.xhtml.startDocument();
        int i = 0;
        do {
            this.inSize = 0;
            while ((i = stream.read(this.input, this.inSize, BUF_SIZE - this.inSize)) > 0) {
                this.inSize += i;
            }
            this.inPos = 0;
            while (this.inPos < this.inSize) {
                byte c_;
                byte c = this.input[this.inPos++];
                boolean utf8 = false;
                if (c == -61) {
                    byte by = c_ = this.inPos < this.inSize ? this.input[this.inPos++] : (byte)stream.read();
                    if (c_ >= -128 && c_ <= -65) {
                        utf8 = true;
                        this.output[this.tmpPos++] = (byte)(c_ + 64);
                    } else {
                        this.output[this.tmpPos++] = c;
                        c = c_;
                    }
                    if (this.tmpPos == BUF_SIZE) {
                        this.flushBuffer();
                    }
                } else if (c == -62) {
                    byte by = c_ = this.inPos < this.inSize ? this.input[this.inPos++] : (byte)stream.read();
                    if (c_ >= -96 && c_ <= -65) {
                        utf8 = true;
                        this.output[this.tmpPos++] = c_;
                    } else {
                        this.output[this.tmpPos++] = c;
                        c = c_;
                    }
                    if (this.tmpPos == BUF_SIZE) {
                        this.flushBuffer();
                    }
                }
                if (utf8) continue;
                if (Latin1StringsParser.isChar(c)) {
                    this.output[this.tmpPos++] = c;
                    if (this.tmpPos != BUF_SIZE) continue;
                    this.flushBuffer();
                    continue;
                }
                if (c == 0 && (this.inPos < 3 || !Latin1StringsParser.isChar(this.input[this.inPos - 3])) && (this.inPos + 1 >= this.inSize || !Latin1StringsParser.isChar(this.input[this.inPos + 1]))) continue;
                if (this.tmpPos - this.outPos >= this.minSize) {
                    this.output[this.tmpPos++] = 10;
                    this.outPos = this.tmpPos;
                    if (this.tmpPos != BUF_SIZE) continue;
                    this.flushBuffer();
                    continue;
                }
                this.tmpPos = this.outPos;
            }
        } while (i != -1 && !Thread.currentThread().isInterrupted());
        if (this.tmpPos - this.outPos >= this.minSize) {
            this.output[this.tmpPos++] = 10;
            this.outPos = this.tmpPos;
        }
        this.xhtml.characters(new String(this.output, 0, this.outPos, "windows-1252"));
        this.xhtml.endDocument();
    }
}

