/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.services.storage.Storage;
import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.AutoValue_ObjectWriteConditions;
import javax.annotation.Nullable;

@AutoValue
public abstract class ObjectWriteConditions {
    public static final ObjectWriteConditions NONE = ObjectWriteConditions.builder().build();

    public static Builder builder() {
        return new AutoValue_ObjectWriteConditions.Builder().setMetaGenerationMatch(null).setContentGenerationMatch(null);
    }

    public abstract Builder toBuilder();

    @Nullable
    public abstract Long getMetaGenerationMatch();

    public boolean hasMetaGenerationMatch() {
        return this.getMetaGenerationMatch() != null;
    }

    @Nullable
    public abstract Long getContentGenerationMatch();

    public boolean hasContentGenerationMatch() {
        return this.getContentGenerationMatch() != null;
    }

    public void apply(Storage.Objects.Insert objectToInsert) {
        if (this.hasContentGenerationMatch()) {
            objectToInsert.setIfGenerationMatch(this.getContentGenerationMatch());
        }
        if (this.hasMetaGenerationMatch()) {
            objectToInsert.setIfMetagenerationMatch(this.getMetaGenerationMatch());
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMetaGenerationMatch(Long var1);

        public abstract Builder setContentGenerationMatch(Long var1);

        public abstract ObjectWriteConditions build();
    }
}

