/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.png;

import com.drew.lang.annotations.NotNull;

public class PngColorType {
    public static final PngColorType GREYSCALE = new PngColorType(0, "Greyscale", 1, 2, 4, 8, 16);
    public static final PngColorType TRUE_COLOR = new PngColorType(2, "True Color", 8, 16);
    public static final PngColorType INDEXED_COLOR = new PngColorType(3, "Indexed Color", 1, 2, 4, 8);
    public static final PngColorType GREYSCALE_WITH_ALPHA = new PngColorType(4, "Greyscale with Alpha", 8, 16);
    public static final PngColorType TRUE_COLOR_WITH_ALPHA = new PngColorType(6, "True Color with Alpha", 8, 16);
    private final int _numericValue;
    @NotNull
    private final String _description;
    @NotNull
    private final int[] _allowedBitDepths;

    @NotNull
    public static PngColorType fromNumericValue(int numericValue) {
        switch (numericValue) {
            case 0: {
                return GREYSCALE;
            }
            case 2: {
                return TRUE_COLOR;
            }
            case 3: {
                return INDEXED_COLOR;
            }
            case 4: {
                return GREYSCALE_WITH_ALPHA;
            }
            case 6: {
                return TRUE_COLOR_WITH_ALPHA;
            }
        }
        return new PngColorType(numericValue, "Unknown (" + numericValue + ")", new int[0]);
    }

    private PngColorType(int numericValue, @NotNull String description, int ... allowedBitDepths) {
        this._numericValue = numericValue;
        this._description = description;
        this._allowedBitDepths = allowedBitDepths;
    }

    public int getNumericValue() {
        return this._numericValue;
    }

    @NotNull
    public String getDescription() {
        return this._description;
    }

    @NotNull
    public int[] getAllowedBitDepths() {
        return this._allowedBitDepths;
    }
}

