/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.android;

import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public final class FixedSecureRandom
extends SecureRandom {
    private static final long serialVersionUID = 0L;
    private static final int VERSION_CODE_JELLY_BEAN_MR2 = 18;
    private static final byte[] BUILD_FINGERPRINT_AND_DEVICE_SERIAL = FixedSecureRandom.getBuildFingerprintAndDeviceSerial();

    public static SecureRandom get() {
        if (Build.VERSION.SDK_INT > 18) {
            return new SecureRandom();
        }
        return new FixedSecureRandom();
    }

    private FixedSecureRandom() {
        super(new LinuxPrngSecureRandomSpi(), new LinuxPrngSecureRandomProvider());
    }

    private static byte[] generateSeed() {
        try {
            ByteArrayOutputStream seedBuffer = new ByteArrayOutputStream();
            DataOutputStream seedBufferOut = new DataOutputStream(seedBuffer);
            seedBufferOut.writeLong(System.currentTimeMillis());
            seedBufferOut.writeLong(System.nanoTime());
            seedBufferOut.writeInt(Process.myPid());
            seedBufferOut.writeInt(Process.myUid());
            seedBufferOut.write(BUILD_FINGERPRINT_AND_DEVICE_SERIAL);
            seedBufferOut.close();
            return seedBuffer.toByteArray();
        }
        catch (IOException e) {
            throw new SecurityException("Failed to generate seed", e);
        }
    }

    private static String getDeviceSerialNumber() {
        try {
            return (String)Build.class.getField("SERIAL").get(null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static byte[] getBuildFingerprintAndDeviceSerial() {
        String serial;
        StringBuilder result = new StringBuilder();
        String fingerprint = Build.FINGERPRINT;
        if (fingerprint != null) {
            result.append(fingerprint);
        }
        if ((serial = FixedSecureRandom.getDeviceSerialNumber()) != null) {
            result.append(serial);
        }
        try {
            return result.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
    }

    public static class LinuxPrngSecureRandomSpi
    extends SecureRandomSpi {
        private static final long serialVersionUID = 0L;
        private static final File URANDOM_FILE = new File("/dev/urandom");
        private static final Object sLock = new Object();
        private static DataInputStream sUrandomIn;
        private static OutputStream sUrandomOut;
        private boolean mSeeded;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineSetSeed(byte[] bytes) {
            try {
                OutputStream out;
                Object object = sLock;
                synchronized (object) {
                    out = this.getUrandomOutputStream();
                }
                out.write(bytes);
                out.flush();
            }
            catch (IOException e) {
                Log.w((String)LinuxPrngSecureRandomSpi.class.getSimpleName(), (String)("Failed to mix seed into " + URANDOM_FILE));
            }
            finally {
                this.mSeeded = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineNextBytes(byte[] bytes) {
            if (!this.mSeeded) {
                this.engineSetSeed(FixedSecureRandom.generateSeed());
            }
            try {
                DataInputStream in;
                Object object = sLock;
                synchronized (object) {
                    in = this.getUrandomInputStream();
                }
                object = in;
                synchronized (object) {
                    in.readFully(bytes);
                }
            }
            catch (IOException e) {
                throw new SecurityException("Failed to read from " + URANDOM_FILE, e);
            }
        }

        @Override
        protected byte[] engineGenerateSeed(int size) {
            byte[] seed = new byte[size];
            this.engineNextBytes(seed);
            return seed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DataInputStream getUrandomInputStream() {
            Object object = sLock;
            synchronized (object) {
                if (sUrandomIn == null) {
                    try {
                        sUrandomIn = new DataInputStream(new FileInputStream(URANDOM_FILE));
                    }
                    catch (IOException e) {
                        throw new SecurityException("Failed to open " + URANDOM_FILE + " for reading", e);
                    }
                }
                return sUrandomIn;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OutputStream getUrandomOutputStream() throws IOException {
            Object object = sLock;
            synchronized (object) {
                if (sUrandomOut == null) {
                    sUrandomOut = new FileOutputStream(URANDOM_FILE);
                }
                return sUrandomOut;
            }
        }
    }

    private static class LinuxPrngSecureRandomProvider
    extends Provider {
        private static final long serialVersionUID = 0L;

        public LinuxPrngSecureRandomProvider() {
            super("LinuxPRNG", 1.0, "A Linux-specific random number provider that uses /dev/urandom");
            this.put("SecureRandom.SHA1PRNG", LinuxPrngSecureRandomSpi.class.getName());
            this.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
        }
    }
}

