/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.UserResendEmailsResult;
import com.dropbox.core.v2.team.UserSelectorArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class UserResendResult {
    public static final UserResendResult OTHER = new UserResendResult().withTag(Tag.OTHER);
    private Tag _tag;
    private UserResendEmailsResult successValue;
    private UserSelectorArg invalidUserValue;

    private UserResendResult() {
    }

    private UserResendResult withTag(Tag _tag) {
        UserResendResult result = new UserResendResult();
        result._tag = _tag;
        return result;
    }

    private UserResendResult withTagAndSuccess(Tag _tag, UserResendEmailsResult successValue) {
        UserResendResult result = new UserResendResult();
        result._tag = _tag;
        result.successValue = successValue;
        return result;
    }

    private UserResendResult withTagAndInvalidUser(Tag _tag, UserSelectorArg invalidUserValue) {
        UserResendResult result = new UserResendResult();
        result._tag = _tag;
        result.invalidUserValue = invalidUserValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isSuccess() {
        return this._tag == Tag.SUCCESS;
    }

    public static UserResendResult success(UserResendEmailsResult value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserResendResult().withTagAndSuccess(Tag.SUCCESS, value);
    }

    public UserResendEmailsResult getSuccessValue() {
        if (this._tag != Tag.SUCCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.SUCCESS, but was Tag." + this._tag.name());
        }
        return this.successValue;
    }

    public boolean isInvalidUser() {
        return this._tag == Tag.INVALID_USER;
    }

    public static UserResendResult invalidUser(UserSelectorArg value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserResendResult().withTagAndInvalidUser(Tag.INVALID_USER, value);
    }

    public UserSelectorArg getInvalidUserValue() {
        if (this._tag != Tag.INVALID_USER) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_USER, but was Tag." + this._tag.name());
        }
        return this.invalidUserValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.successValue, this.invalidUserValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UserResendResult) {
            UserResendResult other = (UserResendResult)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case SUCCESS: {
                    return this.successValue == other.successValue || this.successValue.equals(other.successValue);
                }
                case INVALID_USER: {
                    return this.invalidUserValue == other.invalidUserValue || this.invalidUserValue.equals(other.invalidUserValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UserResendResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserResendResult value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case SUCCESS: {
                    g.writeStartObject();
                    this.writeTag("success", g);
                    UserResendEmailsResult.Serializer.INSTANCE.serialize(value.successValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case INVALID_USER: {
                    g.writeStartObject();
                    this.writeTag("invalid_user", g);
                    g.writeFieldName("invalid_user");
                    UserSelectorArg.Serializer.INSTANCE.serialize(value.invalidUserValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public UserResendResult deserialize(JsonParser p) throws IOException, JsonParseException {
            UserResendResult value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("success".equals(tag)) {
                UserResendEmailsResult fieldValue = null;
                fieldValue = UserResendEmailsResult.Serializer.INSTANCE.deserialize(p, true);
                value = UserResendResult.success(fieldValue);
            } else if ("invalid_user".equals(tag)) {
                UserSelectorArg fieldValue = null;
                Serializer.expectField("invalid_user", p);
                fieldValue = UserSelectorArg.Serializer.INSTANCE.deserialize(p);
                value = UserResendResult.invalidUser(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        SUCCESS,
        INVALID_USER,
        OTHER;

    }
}

