/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class TeamFolderRenameDetails {
    protected final String previousFolderName;
    protected final String newFolderName;

    public TeamFolderRenameDetails(String previousFolderName, String newFolderName) {
        if (previousFolderName == null) {
            throw new IllegalArgumentException("Required value for 'previousFolderName' is null");
        }
        this.previousFolderName = previousFolderName;
        if (newFolderName == null) {
            throw new IllegalArgumentException("Required value for 'newFolderName' is null");
        }
        this.newFolderName = newFolderName;
    }

    public String getPreviousFolderName() {
        return this.previousFolderName;
    }

    public String getNewFolderName() {
        return this.newFolderName;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.previousFolderName, this.newFolderName});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamFolderRenameDetails other = (TeamFolderRenameDetails)obj;
            return !(this.previousFolderName != other.previousFolderName && !this.previousFolderName.equals(other.previousFolderName) || this.newFolderName != other.newFolderName && !this.newFolderName.equals(other.newFolderName));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamFolderRenameDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamFolderRenameDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("previous_folder_name");
            StoneSerializers.string().serialize(value.previousFolderName, g);
            g.writeFieldName("new_folder_name");
            StoneSerializers.string().serialize(value.newFolderName, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamFolderRenameDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_newFolderName;
            String f_previousFolderName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_previousFolderName = null;
                f_newFolderName = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("previous_folder_name".equals(field)) {
                        f_previousFolderName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("new_folder_name".equals(field)) {
                        f_newFolderName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_previousFolderName == null) {
                    throw new JsonParseException(p, "Required field \"previous_folder_name\" missing.");
                }
                if (f_newFolderName == null) {
                    throw new JsonParseException(p, "Required field \"new_folder_name\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamFolderRenameDetails value = new TeamFolderRenameDetails(f_previousFolderName, f_newFolderName);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

