/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.delete;

import java.sql.SQLException;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.delete.DeleteData;
import org.apache.hop.pipeline.transforms.delete.DeleteKeyField;
import org.apache.hop.pipeline.transforms.delete.DeleteMeta;

public class Delete
extends BaseTransform<DeleteMeta, DeleteData> {
    private static final Class<?> PKG = DeleteMeta.class;

    public Delete(TransformMeta transformMeta, DeleteMeta meta, DeleteData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private synchronized void deleteValues(IRowMeta rowMeta, Object[] row) throws HopException {
        Object[] deleteRow = new Object[((DeleteData)this.data).deleteParameterRowMeta.size()];
        int deleteIndex = 0;
        List<DeleteKeyField> keyFields = ((DeleteMeta)this.meta).getLookup().getFields();
        for (int i = 0; i < keyFields.size(); ++i) {
            if (((DeleteData)this.data).keynrs[i] >= 0) {
                deleteRow[deleteIndex] = row[((DeleteData)this.data).keynrs[i]];
                ++deleteIndex;
            }
            if (((DeleteData)this.data).keynrs2[i] < 0) continue;
            deleteRow[deleteIndex] = row[((DeleteData)this.data).keynrs2[i]];
            ++deleteIndex;
        }
        ((DeleteData)this.data).db.setValues(((DeleteData)this.data).deleteParameterRowMeta, deleteRow, ((DeleteData)this.data).prepStatementDelete);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"Delete.Log.SetValuesForDelete", (String[])new String[]{((DeleteData)this.data).deleteParameterRowMeta.getString(deleteRow), rowMeta.getString(row)}));
        }
        ((DeleteData)this.data).db.insertRow(((DeleteData)this.data).prepStatementDelete);
        this.incrementLinesUpdated();
    }

    public boolean processRow() throws HopException {
        block10: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((DeleteData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((DeleteMeta)this.meta).getFields(((DeleteData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((DeleteMeta)this.meta).getConnection(), this.variables);
                ((DeleteData)this.data).schemaTable = databaseMeta.getQuotedSchemaTableCombination((IVariables)this, ((DeleteMeta)this.meta).getLookup().getSchemaName(), ((DeleteMeta)this.meta).getLookup().getTableName());
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Delete.Log.CheckingRow", (String[])new String[0]) + this.getInputRowMeta().getString(r));
                }
                List<DeleteKeyField> keyFields = ((DeleteMeta)this.meta).getLookup().getFields();
                ((DeleteData)this.data).keynrs = new int[keyFields.size()];
                ((DeleteData)this.data).keynrs2 = new int[keyFields.size()];
                for (int i = 0; i < keyFields.size(); ++i) {
                    DeleteKeyField dlf = keyFields.get(i);
                    ((DeleteData)this.data).keynrs[i] = this.getInputRowMeta().indexOfValue(dlf.getKeyStream());
                    if (((DeleteData)this.data).keynrs[i] < 0 && !"IS NULL".equalsIgnoreCase(dlf.getKeyCondition()) && !"IS NOT NULL".equalsIgnoreCase(dlf.getKeyCondition())) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"Delete.Exception.FieldRequired", (String[])new String[]{dlf.getKeyStream()}));
                    }
                    int n = ((DeleteData)this.data).keynrs2[i] = dlf.getKeyStream2() == null ? -1 : this.getInputRowMeta().indexOfValue(dlf.getKeyStream2());
                    if (((DeleteData)this.data).keynrs2[i] < 0 && "BETWEEN".equalsIgnoreCase(dlf.getKeyCondition())) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"Delete.Exception.FieldRequired", (String[])new String[]{dlf.getKeyStream2()}));
                    }
                    if (!this.log.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"Delete.Log.FieldInfo", (String[])new String[]{dlf.getKeyStream()}) + ((DeleteData)this.data).keynrs[i]);
                }
                this.prepareDelete(this.getInputRowMeta());
            }
            try {
                this.deleteValues(this.getInputRowMeta(), r);
                this.putRow(((DeleteData)this.data).outputRowMeta, r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"Delete.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"Delete.Log.ErrorInTransform", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block10;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DEL001");
            }
        }
        return true;
    }

    public void prepareDelete(IRowMeta rowMeta) throws HopDatabaseException {
        DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((DeleteMeta)this.meta).getConnection(), this.variables);
        ((DeleteData)this.data).deleteParameterRowMeta = new RowMeta();
        String sql = "DELETE FROM " + ((DeleteData)this.data).schemaTable + Const.CR;
        sql = sql + "WHERE ";
        List<DeleteKeyField> keyFields = ((DeleteMeta)this.meta).getLookup().getFields();
        for (int i = 0; i < keyFields.size(); ++i) {
            DeleteKeyField dlkf = keyFields.get(i);
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + databaseMeta.quoteField(dlkf.getKeyLookup());
            if ("BETWEEN".equalsIgnoreCase(dlkf.getKeyCondition())) {
                sql = sql + " BETWEEN ? AND ? ";
                ((DeleteData)this.data).deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(dlkf.getKeyStream()));
                ((DeleteData)this.data).deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(dlkf.getKeyStream2()));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(dlkf.getKeyCondition()) || "IS NOT NULL".equalsIgnoreCase(dlkf.getKeyCondition())) {
                sql = sql + " " + dlkf.getKeyCondition() + " ";
                continue;
            }
            sql = sql + " " + dlkf.getKeyCondition() + " ? ";
            ((DeleteData)this.data).deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(dlkf.getKeyStream()));
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting delete preparedStatement to [" + sql + "]");
            }
            ((DeleteData)this.data).prepStatementDelete = ((DeleteData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((DeleteMeta)this.meta).getConnection())) {
                this.logError(BaseMessages.getString(PKG, (String)"Delete.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                return false;
            }
            DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((DeleteMeta)this.meta).getConnection(), this.variables);
            if (databaseMeta == null) {
                this.logError(BaseMessages.getString(PKG, (String)"Delete.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                return false;
            }
            ((DeleteData)this.data).db = new Database((ILoggingObject)this, this.variables, databaseMeta);
            try {
                ((DeleteData)this.data).db.connect();
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Delete.Log.ConnectedToDB", (String[])new String[0]));
                }
                ((DeleteData)this.data).db.setCommit(((DeleteMeta)this.meta).getCommitSize((IVariables)this));
                return true;
            }
            catch (HopException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"Delete.Log.ErrorOccurred", (String[])new String[0]) + ke.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public void batchComplete() throws HopException {
        this.commitBatch(false);
    }

    public void dispose() {
        this.commitBatch(true);
        super.dispose();
    }

    private void commitBatch(boolean dispose) {
        if (((DeleteData)this.data).db != null) {
            try {
                if (!((DeleteData)this.data).db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        ((DeleteData)this.data).db.commit();
                    } else {
                        ((DeleteData)this.data).db.rollback();
                    }
                }
                if (dispose) {
                    ((DeleteData)this.data).db.closeUpdate();
                }
            }
            catch (HopDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"Delete.Log.UnableToCommitUpdateConnection", (String[])new String[0]) + ((DeleteData)this.data).db + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                if (dispose) {
                    ((DeleteData)this.data).db.disconnect();
                    ((DeleteData)this.data).db = null;
                }
            }
        }
    }
}

