/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.probes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkExecutionAwareProbe;
import org.yardstickframework.BenchmarkProbePoint;
import org.yardstickframework.BenchmarkUtils;

public class ThroughputLatencyProbe
implements BenchmarkExecutionAwareProbe {
    private ThreadAgent[] agents;
    private Collection<BenchmarkProbePoint> collected = new ArrayList<BenchmarkProbePoint>();
    private ExecutorService buildingService;
    private BenchmarkConfiguration cfg;
    private volatile long lastTstamp;

    @Override
    public void start(BenchmarkDriver drv, BenchmarkConfiguration cfg) throws Exception {
        this.cfg = cfg;
        this.agents = new ThreadAgent[cfg.threads()];
        for (int i = 0; i < this.agents.length; ++i) {
            this.agents[i] = new ThreadAgent();
        }
        this.buildingService = Executors.newSingleThreadExecutor();
        BenchmarkUtils.println(cfg, this.getClass().getSimpleName() + " is started.");
        this.lastTstamp = System.currentTimeMillis();
    }

    @Override
    public void stop() throws Exception {
        if (this.buildingService != null) {
            this.buildingService.shutdownNow();
            this.buildingService.awaitTermination(1L, TimeUnit.MINUTES);
            BenchmarkUtils.println(this.cfg, this.getClass().getSimpleName() + " is stopped.");
        }
    }

    @Override
    public Collection<String> metaInfo() {
        return Arrays.asList("Time, sec", "Operations/sec (more is better)", "Latency, nsec (less is better)");
    }

    @Override
    public synchronized Collection<BenchmarkProbePoint> points() {
        Collection<BenchmarkProbePoint> ret = this.collected;
        this.collected = new ArrayList<BenchmarkProbePoint>(ret.size() + 5);
        return ret;
    }

    @Override
    public void buildPoint(final long time) {
        this.buildingService.execute(new Runnable(){

            @Override
            public void run() {
                long lastTstamp0 = ThroughputLatencyProbe.this.lastTstamp;
                long lastTstamp1 = System.currentTimeMillis();
                ThroughputLatencyProbe.this.lastTstamp = lastTstamp1;
                long delta = (long)Math.floor((double)(lastTstamp1 - lastTstamp0) / 1000.0 + 0.5);
                ThreadAgent collector = new ThreadAgent();
                for (ThreadAgent agent : ThroughputLatencyProbe.this.agents) {
                    agent.collect(collector);
                }
                double latency = collector.execCnt == 0L ? 0.0 : (double)collector.totalLatency / (double)collector.execCnt;
                BenchmarkProbePoint pnt = new BenchmarkProbePoint(TimeUnit.MILLISECONDS.toSeconds(time), new double[]{delta == 0L ? Double.NaN : (double)collector.execCnt / (double)delta, latency});
                ThroughputLatencyProbe.this.collectPoint(pnt);
            }
        });
    }

    private synchronized void collectPoint(BenchmarkProbePoint pnt) {
        this.collected.add(pnt);
    }

    @Override
    public void beforeExecute(int threadIdx) {
        this.agents[threadIdx].beforeExecute();
    }

    @Override
    public void afterExecute(int threadIdx) {
        this.agents[threadIdx].afterExecute();
    }

    private static class ThreadAgent {
        private long execCnt;
        private long totalLatency;
        private long beforeTs;

        private ThreadAgent() {
        }

        public void beforeExecute() {
            this.beforeTs = System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterExecute() {
            long latency = System.nanoTime() - this.beforeTs;
            this.beforeTs = 0L;
            ThreadAgent threadAgent = this;
            synchronized (threadAgent) {
                ++this.execCnt;
                this.totalLatency += latency;
            }
        }

        public synchronized void collect(ThreadAgent other) {
            other.execCnt += this.execCnt;
            other.totalLatency += this.totalLatency;
            this.execCnt = 0L;
            this.totalLatency = 0L;
        }
    }
}

