/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.hint;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.calcite.hint.HintDefinition;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;

public final class HintUtils {
    private HintUtils() {
    }

    public static Collection<String> options(RelNode rel, Collection<RelHint> hints, HintDefinition hintDef) {
        return F.flatCollections((Collection)HintUtils.filterHints(rel, hints, Collections.singletonList(hintDef)).stream().map(h -> h.listOptions).collect(Collectors.toList()));
    }

    public static List<RelHint> hints(RelNode rel, HintDefinition ... hintDefs) {
        return HintUtils.hints(rel, HintUtils.allRelHints(rel), hintDefs);
    }

    public static List<RelHint> hints(RelNode rel, Collection<RelHint> hints, HintDefinition ... hintDefs) {
        return rel.getCluster().getHintStrategies().apply(HintUtils.filterHints(rel, hints, Arrays.asList(hintDefs)), rel);
    }

    public static List<RelHint> allRelHints(RelNode rel) {
        return rel instanceof Hintable ? ((Hintable)rel).getHints() : Collections.emptyList();
    }

    public static List<RelHint> nonInheritedRelHints(RelNode rel) {
        return rel instanceof Hintable ? ((Hintable)rel).getHints().stream().filter(hint -> hint.inheritPath.isEmpty()).collect(Collectors.toList()) : Collections.emptyList();
    }

    private static List<RelHint> filterHints(RelNode rel, Collection<RelHint> hints, List<HintDefinition> hintDefs) {
        Set requiredHintDefs = hintDefs.stream().map(Enum::name).collect(Collectors.toSet());
        List<RelHint> res = hints.stream().filter(h -> requiredHintDefs.contains(h.hintName)).map(h -> {
            RelHint.Builder rb = RelHint.builder((String)h.hintName);
            if (!h.listOptions.isEmpty()) {
                rb.hintOptions((Iterable)h.listOptions);
            } else if (!h.kvOptions.isEmpty()) {
                rb.hintOptions(h.kvOptions);
            }
            return rb.build();
        }).distinct().collect(Collectors.toList());
        Iterator it = res.iterator();
        while (it.hasNext()) {
            RelHint hint = (RelHint)it.next();
            String optsErr = (String)HintDefinition.valueOf(hint.hintName).optionsChecker().apply(hint);
            if (F.isEmpty((String)optsErr)) continue;
            HintUtils.skippedHint(rel, hint, optsErr);
            it.remove();
        }
        return res;
    }

    public static boolean isExpandDistinctAggregate(LogicalAggregate rel) {
        return !HintUtils.hints((RelNode)rel, HintDefinition.EXPAND_DISTINCT_AGG).isEmpty() && rel.getAggCallList().stream().anyMatch(AggregateCall::isDistinct);
    }

    public static void skippedHint(RelNode relNode, RelHint hint, String reason) {
        IgniteLogger log = Commons.context(relNode).unwrap(BaseQueryContext.class).logger();
        if (log.isDebugEnabled()) {
            String hintOptions;
            String string = hintOptions = hint.listOptions.isEmpty() ? "" : "with options " + hint.listOptions.stream().map(o -> "'" + o + "'").collect(Collectors.joining(",")) + " ";
            if (!relNode.getInputs().isEmpty()) {
                relNode = HintUtils.noInputsRelWrap(relNode);
            }
            log.debug(String.format("Skipped hint '%s' %sfor relation operator '%s'. %s", hint.hintName, hintOptions, RelOptUtil.toString((RelNode)relNode, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES).trim(), reason));
        }
    }

    public static RelNode noInputsRelWrap(RelNode rel) {
        return new NoInputsRelNodeWrap(rel);
    }

    private static final class NoInputsRelNodeWrap
    extends AbstractRelNode {
        private final RelNode rel;

        private NoInputsRelNodeWrap(RelNode relNode) {
            super(relNode.getCluster(), relNode.getTraitSet());
            this.rel = relNode;
        }

        public List<RelNode> getInputs() {
            return Collections.emptyList();
        }

        public RelNode getInput(int i) {
            throw new UnsupportedOperationException("Failed to pass any node input. This a no-inputs node.");
        }

        protected RelDataType deriveRowType() {
            return this.rel.getRowType();
        }

        public void explain(RelWriter pw) {
            this.rel.explain(pw);
        }
    }
}

