/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.management.cache.CacheCreateCommandArg;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecurityPermissionSetBuilder;
import org.apache.ignite.resources.IgniteInstanceResource;

@GridInternal
public class CacheCreateTask
extends VisorOneNodeTask<CacheCreateCommandArg, Set<String>> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<CacheCreateCommandArg, Set<String>> job(CacheCreateCommandArg springXmlConfig) {
        return new CacheCreateJob(springXmlConfig, false);
    }

    private static class CacheCreateJob
    extends VisorJob<CacheCreateCommandArg, Set<String>> {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected transient IgniteEx ignite;

        protected CacheCreateJob(CacheCreateCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Set<String> run(CacheCreateCommandArg arg) throws IgniteException {
            Collection<IgniteCache> caches;
            Collection<CacheConfiguration> ccfgs;
            IgniteSpringHelper spring;
            if (F.isEmpty(arg.fileContent())) {
                throw new IllegalArgumentException("Configurations not specified.");
            }
            try {
                spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to create caches. " + IgniteComponentType.SPRING.module() + " module is not configured.", e);
            }
            try {
                ccfgs = spring.loadConfigurations((InputStream)new ByteArrayInputStream(arg.fileContent().getBytes()), CacheConfiguration.class, false, new String[0]).get1();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to create caches. Make sure that Spring XML contains '" + CacheConfiguration.class.getName() + "' beans.", e);
            }
            if (arg.skipExisting()) {
                Collection<String> existingCacheNames = this.ignite.cacheNames();
                ccfgs.removeIf(ccfg -> ccfg.getName() != null && existingCacheNames.contains(ccfg.getName()));
                caches = this.ignite.getOrCreateCaches(ccfgs);
            } else {
                caches = this.ignite.createCaches(ccfgs);
            }
            return caches.stream().map(Cache::getName).collect(Collectors.toCollection(TreeSet::new));
        }

        @Override
        public SecurityPermissionSet requiredPermissions() {
            return SecurityPermissionSetBuilder.NO_PERMISSIONS;
        }
    }
}

