/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.discovery;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collection;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.jobmetrics.GridJobMetrics;
import org.apache.ignite.internal.processors.metric.MetricRegistryImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.metric.DoubleMetric;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.spi.metric.LongMetric;

public class ClusterMetricsImpl
implements ClusterMetrics {
    private static final RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
    private volatile GridJobMetrics jobMetrics;
    private volatile long jobMetricsUpdateTime;
    private final Object jobMetricsMux = new Object();
    private final GridKernalContext ctx;
    private final long nodeStartTime;
    private final LongMetric execTasks;
    private final DoubleMetric gcCpuLoad;
    private final DoubleMetric cpuLoad;
    private final LongMetric upTime;
    private final int availableProcessors;
    private final LongMetric heapInit;
    private final LongMetric heapUsed;
    private final LongMetric heapCommitted;
    private final LongMetric heapMax;
    private final LongMetric nonHeapInit;
    private final LongMetric nonHeapUsed;
    private final LongMetric nonHeapCommitted;
    private final LongMetric nonHeapMax;
    private final IntMetric threadCnt;
    private final LongMetric lastDataVer;
    private final IntMetric sentMsgsCnt;
    private final LongMetric sentBytesCnt;
    private final IntMetric rcvdMsgsCnt;
    private final LongMetric rcvdBytesCnt;
    private final IntMetric outboundMsgCnt;
    private final IntMetric peakThreadCnt;
    private final LongMetric totalStartedThreadCnt;
    private final IntMetric daemonThreadCnt;
    private final LongMetric pmeDuration;

    public ClusterMetricsImpl(GridKernalContext ctx, long nodeStartTime) {
        this.ctx = ctx;
        this.nodeStartTime = nodeStartTime;
        MetricRegistryImpl mreg = ctx.metric().registry("sys");
        this.gcCpuLoad = (DoubleMetric)mreg.findMetric("GcCpuLoad");
        this.cpuLoad = (DoubleMetric)mreg.findMetric("CpuLoad");
        this.upTime = (LongMetric)mreg.findMetric("UpTime");
        this.threadCnt = (IntMetric)mreg.findMetric("ThreadCount");
        this.peakThreadCnt = (IntMetric)mreg.findMetric("PeakThreadCount");
        this.totalStartedThreadCnt = (LongMetric)mreg.findMetric("TotalStartedThreadCount");
        this.daemonThreadCnt = (IntMetric)mreg.findMetric("DaemonThreadCount");
        this.execTasks = (LongMetric)mreg.findMetric("TotalExecutedTasks");
        this.availableProcessors = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        this.heapInit = (LongMetric)mreg.findMetric(MetricUtils.metricName("memory", "heap", "init"));
        this.heapUsed = (LongMetric)mreg.findMetric(MetricUtils.metricName("memory", "heap", "used"));
        this.heapCommitted = (LongMetric)mreg.findMetric(MetricUtils.metricName("memory", "heap", "committed"));
        this.heapMax = (LongMetric)mreg.findMetric(MetricUtils.metricName("memory", "heap", "max"));
        this.nonHeapInit = (LongMetric)mreg.findMetric(MetricUtils.metricName("memory", "nonheap", "init"));
        this.nonHeapUsed = (LongMetric)mreg.findMetric(MetricUtils.metricName("memory", "nonheap", "used"));
        this.nonHeapCommitted = (LongMetric)mreg.findMetric(MetricUtils.metricName("memory", "nonheap", "committed"));
        this.nonHeapMax = (LongMetric)mreg.findMetric(MetricUtils.metricName("memory", "nonheap", "max"));
        MetricRegistryImpl pmeReg = ctx.metric().registry("pme");
        this.pmeDuration = (LongMetric)pmeReg.findMetric("Duration");
        this.lastDataVer = (LongMetric)ctx.metric().registry("cache").findMetric("LastDataVersion");
        MetricRegistryImpl ioReg = ctx.metric().registry(GridIoManager.COMM_METRICS);
        this.sentMsgsCnt = (IntMetric)ioReg.findMetric("SentMessagesCount");
        this.sentBytesCnt = (LongMetric)ioReg.findMetric("SentBytesCount");
        this.rcvdMsgsCnt = (IntMetric)ioReg.findMetric("ReceivedMessagesCount");
        this.rcvdBytesCnt = (LongMetric)ioReg.findMetric("ReceivedBytesCount");
        this.outboundMsgCnt = (IntMetric)ioReg.findMetric("OutboundMessagesQueueSize");
    }

    @Override
    public long getLastUpdateTime() {
        return this.jobMetricsUpdateTime == 0L ? U.currentTimeMillis() : this.jobMetricsUpdateTime;
    }

    @Override
    public int getMaximumActiveJobs() {
        return this.jobMetrics().getMaximumActiveJobs();
    }

    @Override
    public int getCurrentActiveJobs() {
        return this.jobMetrics().getCurrentActiveJobs();
    }

    @Override
    public float getAverageActiveJobs() {
        return this.jobMetrics().getAverageActiveJobs();
    }

    @Override
    public int getMaximumWaitingJobs() {
        return this.jobMetrics().getMaximumWaitingJobs();
    }

    @Override
    public int getCurrentWaitingJobs() {
        return this.jobMetrics().getCurrentWaitingJobs();
    }

    @Override
    public float getAverageWaitingJobs() {
        return this.jobMetrics().getAverageWaitingJobs();
    }

    @Override
    public int getMaximumRejectedJobs() {
        return this.jobMetrics().getMaximumRejectedJobs();
    }

    @Override
    public int getCurrentRejectedJobs() {
        return this.jobMetrics().getCurrentRejectedJobs();
    }

    @Override
    public float getAverageRejectedJobs() {
        return this.jobMetrics().getAverageRejectedJobs();
    }

    @Override
    public int getTotalRejectedJobs() {
        return this.jobMetrics().getTotalRejectedJobs();
    }

    @Override
    public int getMaximumCancelledJobs() {
        return this.jobMetrics().getMaximumCancelledJobs();
    }

    @Override
    public int getCurrentCancelledJobs() {
        return this.jobMetrics().getCurrentCancelledJobs();
    }

    @Override
    public float getAverageCancelledJobs() {
        return this.jobMetrics().getAverageCancelledJobs();
    }

    @Override
    public int getTotalCancelledJobs() {
        return this.jobMetrics().getTotalCancelledJobs();
    }

    @Override
    public int getTotalExecutedJobs() {
        return this.jobMetrics().getTotalExecutedJobs();
    }

    @Override
    public long getTotalJobsExecutionTime() {
        return this.jobMetrics().getTotalJobsExecutionTime();
    }

    @Override
    public long getMaximumJobWaitTime() {
        return this.jobMetrics().getMaximumJobWaitTime();
    }

    @Override
    public long getCurrentJobWaitTime() {
        return this.jobMetrics().getCurrentJobWaitTime();
    }

    @Override
    public double getAverageJobWaitTime() {
        return this.jobMetrics().getAverageJobWaitTime();
    }

    @Override
    public long getMaximumJobExecuteTime() {
        return this.jobMetrics().getMaximumJobExecuteTime();
    }

    @Override
    public long getCurrentJobExecuteTime() {
        return this.jobMetrics().getCurrentJobExecuteTime();
    }

    @Override
    public double getAverageJobExecuteTime() {
        return this.jobMetrics().getAverageJobExecuteTime();
    }

    @Override
    public int getTotalExecutedTasks() {
        return (int)this.execTasks.value();
    }

    @Override
    public long getTotalBusyTime() {
        return this.getUpTime() - this.getTotalIdleTime();
    }

    @Override
    public long getTotalIdleTime() {
        return this.jobMetrics().getTotalIdleTime();
    }

    @Override
    public long getCurrentIdleTime() {
        return this.jobMetrics().getCurrentIdleTime();
    }

    @Override
    public float getBusyTimePercentage() {
        return 1.0f - this.getIdleTimePercentage();
    }

    @Override
    public float getIdleTimePercentage() {
        return (float)this.getTotalIdleTime() / (float)this.getUpTime();
    }

    @Override
    public int getTotalCpus() {
        return this.availableProcessors;
    }

    @Override
    public double getCurrentCpuLoad() {
        return this.cpuLoad.value();
    }

    @Override
    public double getAverageCpuLoad() {
        return this.jobMetrics().getAverageCpuLoad();
    }

    @Override
    public double getCurrentGcCpuLoad() {
        return this.gcCpuLoad.value();
    }

    @Override
    public long getHeapMemoryInitialized() {
        return this.heapInit.value();
    }

    @Override
    public long getHeapMemoryUsed() {
        return this.heapUsed.value();
    }

    @Override
    public long getHeapMemoryCommitted() {
        return this.heapCommitted.value();
    }

    @Override
    public long getHeapMemoryMaximum() {
        return this.heapMax.value();
    }

    @Override
    public long getHeapMemoryTotal() {
        return this.heapMax.value();
    }

    @Override
    public long getNonHeapMemoryInitialized() {
        return this.nonHeapInit.value();
    }

    @Override
    public long getNonHeapMemoryUsed() {
        Collection<GridCacheAdapter<?, ?>> caches = this.ctx.cache().internalCaches();
        long nonHeapUsed = this.nonHeapUsed.value();
        for (GridCacheAdapter<?, ?> cache : caches) {
            if (!cache.context().statisticsEnabled() || !cache.context().started() || cache.context().affinity().affinityTopologyVersion().topologyVersion() <= 0L) continue;
            nonHeapUsed += cache.metrics0().getOffHeapAllocatedSize();
        }
        return nonHeapUsed;
    }

    @Override
    public long getNonHeapMemoryCommitted() {
        return this.nonHeapCommitted.value();
    }

    @Override
    public long getNonHeapMemoryMaximum() {
        return this.nonHeapMax.value();
    }

    @Override
    public long getNonHeapMemoryTotal() {
        return this.nonHeapMax.value();
    }

    @Override
    public long getUpTime() {
        return this.upTime.value();
    }

    @Override
    public long getStartTime() {
        return rt.getStartTime();
    }

    @Override
    public long getNodeStartTime() {
        return this.nodeStartTime;
    }

    @Override
    public int getCurrentThreadCount() {
        return this.threadCnt.value();
    }

    @Override
    public int getMaximumThreadCount() {
        return this.peakThreadCnt.value();
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.totalStartedThreadCnt.value();
    }

    @Override
    public int getCurrentDaemonThreadCount() {
        return this.daemonThreadCnt.value();
    }

    @Override
    public long getLastDataVersion() {
        return this.lastDataVer.value();
    }

    @Override
    public int getSentMessagesCount() {
        return this.sentMsgsCnt.value();
    }

    @Override
    public long getSentBytesCount() {
        return this.sentBytesCnt.value();
    }

    @Override
    public int getReceivedMessagesCount() {
        return this.rcvdMsgsCnt.value();
    }

    @Override
    public long getReceivedBytesCount() {
        return this.rcvdBytesCnt.value();
    }

    @Override
    public int getOutboundMessagesQueueSize() {
        return this.outboundMsgCnt.value();
    }

    @Override
    public int getTotalNodes() {
        return 1;
    }

    @Override
    public long getCurrentPmeDuration() {
        return this.pmeDuration.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridJobMetrics jobMetrics() {
        if (this.jobMetrics == null) {
            Object object = this.jobMetricsMux;
            synchronized (object) {
                if (this.jobMetrics == null) {
                    this.jobMetricsUpdateTime = U.currentTimeMillis();
                    this.jobMetrics = this.ctx.jobMetric().getJobMetrics();
                }
            }
        }
        return this.jobMetrics;
    }
}

