/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.List;
import org.apache.ivy.ant.IvyCacheTask;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

public class IvyCachePath
extends IvyCacheTask {
    private String pathid;
    private String id;
    private boolean osgi = false;

    public String getPathid() {
        return this.pathid;
    }

    public void setPathid(String id) {
        this.pathid = id;
    }

    public void setOsgi(boolean osgi) {
        this.osgi = osgi;
    }

    @Deprecated
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.pathid == null) {
            if (this.id == null) {
                throw new BuildException("pathid is required in ivy classpath");
            }
            this.pathid = this.id;
            this.log("ID IS DEPRECATED, PLEASE USE PATHID INSTEAD", 1);
        }
        try {
            Path path = new Path(this.getProject());
            this.getProject().addReference(this.pathid, (Object)path);
            for (ArtifactDownloadReport adr : this.getArtifactReports()) {
                File f = adr.getLocalFile();
                if (adr.getUnpackedLocalFile() != null) {
                    f = adr.getUnpackedLocalFile();
                }
                this.addToPath(path, f);
            }
        }
        catch (Exception ex) {
            throw new BuildException("impossible to build ivy path: " + ex, (Throwable)ex);
        }
    }

    protected void addToPath(Path path, File f) throws Exception {
        if (!this.osgi || !f.isDirectory()) {
            path.createPathElement().setLocation(f);
            return;
        }
        File manifest = new File(f, "META-INF/MANIFEST.MF");
        if (!manifest.exists()) {
            path.createPathElement().setLocation(f);
            return;
        }
        BundleInfo bundleInfo = ManifestParser.parseManifest(manifest);
        List<String> cp = bundleInfo.getClasspath();
        if (cp == null) {
            path.createPathElement().setLocation(f);
            return;
        }
        for (String p : cp) {
            if (p.equals(".")) {
                path.createPathElement().setLocation(f);
                continue;
            }
            path.createPathElement().setLocation(new File(f, p));
        }
    }
}

