/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.call;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallInput;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.core.exception.handler.DefaultExceptionHandlers;
import org.apache.ignite.internal.cli.decorators.DefaultDecorator;
import org.apache.ignite.internal.cli.logger.CliLoggers;

public class CallExecutionPipeline<I extends CallInput, T> {
    private final Call<I, T> call;
    private final PrintWriter output;
    private final PrintWriter errOutput;
    private final Decorator<T, TerminalOutput> decorator;
    private final ExceptionHandlers exceptionHandlers;
    private final Supplier<I> inputProvider;
    private final boolean verbose;

    private CallExecutionPipeline(Call<I, T> call, PrintWriter output, PrintWriter errOutput, ExceptionHandlers exceptionHandlers, Decorator<T, TerminalOutput> decorator, Supplier<I> inputProvider, boolean verbose) {
        this.call = call;
        this.output = output;
        this.exceptionHandlers = exceptionHandlers;
        this.errOutput = errOutput;
        this.decorator = decorator;
        this.inputProvider = inputProvider;
        this.verbose = verbose;
    }

    public static <I extends CallInput, T> CallExecutionPipelineBuilder<I, T> builder(Call<I, T> call) {
        return new CallExecutionPipelineBuilder<I, T>(call);
    }

    public int runPipeline() {
        try {
            if (this.verbose) {
                CliLoggers.startOutputRedirect(this.errOutput);
            }
            int n = this.runPipelineInternal();
            return n;
        }
        finally {
            if (this.verbose) {
                CliLoggers.stopOutputRedirect();
            }
        }
    }

    private int runPipelineInternal() {
        CallInput callInput = (CallInput)this.inputProvider.get();
        CallOutput<T> callOutput = this.call.execute(callInput);
        if (callOutput.hasError()) {
            return this.exceptionHandlers.handleException(ExceptionWriter.fromPrintWriter(this.errOutput), callOutput.errorCause());
        }
        if (!callOutput.isEmpty()) {
            TerminalOutput decoratedOutput = this.decorator.decorate(callOutput.body());
            this.output.println(decoratedOutput.toTerminalString());
        }
        return 0;
    }

    public static class CallExecutionPipelineBuilder<I extends CallInput, T> {
        private final Call<I, T> call;
        private final ExceptionHandlers exceptionHandlers = new DefaultExceptionHandlers();
        private Supplier<I> inputProvider;
        private PrintWriter output = CallExecutionPipelineBuilder.wrapOutputStream(System.out);
        private PrintWriter errOutput = CallExecutionPipelineBuilder.wrapOutputStream(System.err);
        private Decorator<T, TerminalOutput> decorator = new DefaultDecorator<T>();
        private boolean verbose;

        public CallExecutionPipelineBuilder(Call<I, T> call) {
            this.call = call;
        }

        public CallExecutionPipelineBuilder<I, T> inputProvider(Supplier<I> inputProvider) {
            this.inputProvider = inputProvider;
            return this;
        }

        public CallExecutionPipelineBuilder<I, T> output(PrintWriter output) {
            this.output = output;
            return this;
        }

        public CallExecutionPipelineBuilder<I, T> output(OutputStream output) {
            return this.output(CallExecutionPipelineBuilder.wrapOutputStream(output));
        }

        public CallExecutionPipelineBuilder<I, T> errOutput(PrintWriter errOutput) {
            this.errOutput = errOutput;
            return this;
        }

        public CallExecutionPipelineBuilder<I, T> errOutput(OutputStream output) {
            return this.errOutput(CallExecutionPipelineBuilder.wrapOutputStream(output));
        }

        public CallExecutionPipelineBuilder<I, T> exceptionHandler(ExceptionHandler<?> exceptionHandler) {
            this.exceptionHandlers.addExceptionHandler(exceptionHandler);
            return this;
        }

        public CallExecutionPipelineBuilder<I, T> exceptionHandlers(ExceptionHandlers exceptionHandlers) {
            this.exceptionHandlers.addExceptionHandlers(exceptionHandlers);
            return this;
        }

        public CallExecutionPipelineBuilder<I, T> decorator(Decorator<T, TerminalOutput> decorator) {
            this.decorator = decorator;
            return this;
        }

        public CallExecutionPipelineBuilder<I, T> verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public CallExecutionPipeline<I, T> build() {
            return new CallExecutionPipeline<I, T>(this.call, this.output, this.errOutput, this.exceptionHandlers, this.decorator, this.inputProvider, this.verbose);
        }

        private static PrintWriter wrapOutputStream(OutputStream output) {
            return new PrintWriter(output, true, CallExecutionPipelineBuilder.getStdoutEncoding());
        }

        private static Charset getStdoutEncoding() {
            String encoding = System.getProperty("sun.stdout.encoding");
            return encoding != null ? Charset.forName(encoding) : Charset.defaultCharset();
        }
    }
}

