/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.eventlog.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.eventlog.api.Sink;
import org.apache.ignite.internal.eventlog.config.schema.EventLogConfiguration;
import org.apache.ignite.internal.eventlog.config.schema.SinkView;
import org.apache.ignite.internal.eventlog.impl.SinkFactory;
import org.apache.ignite.internal.eventlog.impl.SinkRegistry;

class ConfigurationBasedSinkRegistry
implements SinkRegistry {
    private volatile Map<String, Sink<?>> cache = new HashMap();
    private volatile Map<String, Set<Sink<?>>> cacheByChannel = new HashMap();
    private final SinkFactory sinkFactory;

    ConfigurationBasedSinkRegistry(EventLogConfiguration cfg, SinkFactory sinkFactory) {
        this.sinkFactory = sinkFactory;
        cfg.sinks().listen((ConfigurationListener)new CacheUpdater());
    }

    @Override
    public Sink<?> getByName(String name) {
        return this.cache.get(name);
    }

    @Override
    public Set<Sink<?>> findAllByChannel(String channel) {
        return this.cacheByChannel.get(channel);
    }

    private class CacheUpdater
    implements ConfigurationListener<NamedListView<SinkView>> {
        private CacheUpdater() {
        }

        public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<NamedListView<SinkView>> ctx) {
            NamedListView newListValue = (NamedListView)ctx.newValue();
            HashMap newCache = new HashMap();
            HashMap newCacheByChannel = new HashMap();
            for (SinkView sinkView : newListValue) {
                Sink sink = ConfigurationBasedSinkRegistry.this.sinkFactory.createSink(sinkView);
                newCache.put(sinkView.name(), sink);
                newCacheByChannel.computeIfAbsent(sinkView.channel(), k -> new HashSet()).add(sink);
            }
            for (String type : ConfigurationBasedSinkRegistry.this.cache.keySet()) {
                if (newCache.containsKey(type)) continue;
                ConfigurationBasedSinkRegistry.this.cache.get(type).stop();
            }
            ConfigurationBasedSinkRegistry.this.cache = newCache;
            ConfigurationBasedSinkRegistry.this.cacheByChannel = newCacheByChannel;
            return CompletableFuture.completedFuture(null);
        }
    }
}

