/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser.core;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;

public class ParagraphParser
extends AbstractBlockParser {
    private final Paragraph block = new Paragraph();
    private BlockContent content = new BlockContent();

    @Override
    public BlockContent getBlockContent() {
        return this.content;
    }

    @Override
    public Paragraph getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (!state.isBlank()) {
            return BlockContinue.atIndex(state.getIndex());
        }
        boolean blankLine = state.isBlankLine();
        this.block.setTrailingBlankLine(blankLine);
        return BlockContinue.none();
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
        int indent = state.getIndent();
        if (indent > 0) {
            this.content.add((BasedSequence)PrefixedSubSequence.repeatOf((char)' ', (int)indent, (BasedSequence)line), indent);
        } else {
            this.content.add(line, indent);
        }
    }

    @Override
    public boolean isParagraphParser() {
        return true;
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    public void closeBlock(ParserState state) {
        this.block.setContent(this.content);
        this.content = null;
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        inlineParser.parse(this.getBlock().getContentChars(), (Node)this.getBlock());
    }

    public static class Factory
    implements BlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            return null;
        }
    }
}

