/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partition.replicator.network.command.BuildIndexCommand;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateMinimumActiveTxBeginTimeCommand;
import org.apache.ignite.internal.partition.replicator.network.command.WriteIntentSwitchCommand;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.raft.ReadCommand;
import org.apache.ignite.internal.raft.WriteCommand;
import org.apache.ignite.internal.raft.service.CommandClosure;
import org.apache.ignite.internal.raft.service.CommittedConfiguration;
import org.apache.ignite.internal.raft.service.RaftGroupListener;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.command.SafeTimePropagatingCommand;
import org.apache.ignite.internal.replicator.command.SafeTimeSyncCommand;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaChangeCommand;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowUpgrader;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.storage.BinaryRowAndRowId;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.table.distributed.StorageUpdateHandler;
import org.apache.ignite.internal.table.distributed.TableUtils;
import org.apache.ignite.internal.table.distributed.index.IndexMeta;
import org.apache.ignite.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite.internal.table.distributed.raft.BuildIndexRowVersionChooser;
import org.apache.ignite.internal.table.distributed.raft.MinimumRequiredTimeCollectorService;
import org.apache.ignite.internal.table.distributed.raft.PartitionDataStorage;
import org.apache.ignite.internal.table.distributed.raft.UnexpectedTransactionStateException;
import org.apache.ignite.internal.tx.TransactionResult;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.UpdateCommandResult;
import org.apache.ignite.internal.tx.message.VacuumTxStatesCommand;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.internal.util.SafeTimeValuesTracker;
import org.apache.ignite.internal.util.TrackerClosedException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PartitionListener
implements RaftGroupListener {
    private static final IgniteLogger LOG = Loggers.forClass(PartitionListener.class);
    private final TxManager txManager;
    private final PartitionDataStorage storage;
    private final StorageUpdateHandler storageUpdateHandler;
    private final TxStateStorage txStateStorage;
    private final SafeTimeValuesTracker safeTimeTracker;
    private final PendingComparableValuesTracker<Long, Void> storageIndexTracker;
    private final CatalogService catalogService;
    private final SchemaRegistry schemaRegistry;
    private final IndexMetaStorage indexMetaStorage;
    private final UUID localNodeId;
    private Set<String> currentGroupTopology;
    private final MinimumRequiredTimeCollectorService minTimeCollectorService;

    public PartitionListener(TxManager txManager, PartitionDataStorage partitionDataStorage, StorageUpdateHandler storageUpdateHandler, TxStateStorage txStateStorage, SafeTimeValuesTracker safeTimeTracker, PendingComparableValuesTracker<Long, Void> storageIndexTracker, CatalogService catalogService, SchemaRegistry schemaRegistry, IndexMetaStorage indexMetaStorage, UUID localNodeId, MinimumRequiredTimeCollectorService minTimeCollectorService) {
        this.txManager = txManager;
        this.storage = partitionDataStorage;
        this.storageUpdateHandler = storageUpdateHandler;
        this.txStateStorage = txStateStorage;
        this.safeTimeTracker = safeTimeTracker;
        this.storageIndexTracker = storageIndexTracker;
        this.catalogService = catalogService;
        this.schemaRegistry = schemaRegistry;
        this.indexMetaStorage = indexMetaStorage;
        this.localNodeId = localNodeId;
        this.minTimeCollectorService = minTimeCollectorService;
    }

    public void onRead(Iterator<CommandClosure<ReadCommand>> iterator) {
        iterator.forEachRemaining(clo -> {
            Command command = clo.command();
            assert (false) : "No read commands expected, [cmd=" + String.valueOf(command) + "]";
        });
    }

    public void onWrite(Iterator<CommandClosure<WriteCommand>> iterator) {
        iterator.forEachRemaining(clo -> {
            Command command = clo.command();
            long commandIndex = clo.index();
            long commandTerm = clo.term();
            @Nullable HybridTimestamp safeTimestamp = clo.safeTimestamp();
            assert (safeTimestamp == null || command instanceof SafeTimePropagatingCommand) : command;
            long storagesAppliedIndex = Math.min(this.storage.lastAppliedIndex(), this.txStateStorage.lastAppliedIndex());
            assert (commandIndex > storagesAppliedIndex) : "Write command must have an index greater than that of storages [commandIndex=" + commandIndex + ", mvAppliedIndex=" + this.storage.lastAppliedIndex() + ", txStateAppliedIndex=" + this.txStateStorage.lastAppliedIndex() + "]";
            IgniteBiTuple<Serializable, Boolean> result = null;
            this.storage.acquirePartitionSnapshotsReadLock();
            try {
                if (command instanceof UpdateCommand) {
                    result = this.handleUpdateCommand((UpdateCommand)command, commandIndex, commandTerm, safeTimestamp);
                } else if (command instanceof UpdateAllCommand) {
                    result = this.handleUpdateAllCommand((UpdateAllCommand)command, commandIndex, commandTerm, safeTimestamp);
                } else if (command instanceof FinishTxCommand) {
                    result = this.handleFinishTxCommand((FinishTxCommand)command, commandIndex, commandTerm);
                } else if (command instanceof WriteIntentSwitchCommand) {
                    result = this.handleWriteIntentSwitchCommand((WriteIntentSwitchCommand)command, commandIndex, commandTerm);
                } else if (command instanceof SafeTimeSyncCommand) {
                    result = this.handleSafeTimeSyncCommand((SafeTimeSyncCommand)command, commandIndex, commandTerm);
                } else if (command instanceof BuildIndexCommand) {
                    result = this.handleBuildIndexCommand((BuildIndexCommand)command, commandIndex, commandTerm);
                } else if (command instanceof PrimaryReplicaChangeCommand) {
                    result = this.handlePrimaryReplicaChangeCommand((PrimaryReplicaChangeCommand)command, commandIndex, commandTerm);
                } else if (command instanceof VacuumTxStatesCommand) {
                    result = this.handleVacuumTxStatesCommand((VacuumTxStatesCommand)command, commandIndex, commandTerm);
                } else if (command instanceof UpdateMinimumActiveTxBeginTimeCommand) {
                    result = this.handleUpdateMinimalActiveTxTimeCommand((UpdateMinimumActiveTxBeginTimeCommand)command, commandIndex, commandTerm);
                } else assert (false) : "Command was not found [cmd=" + String.valueOf(command) + "]";
                if (Boolean.TRUE.equals(result.get2())) {
                    if (safeTimestamp != null) {
                        PartitionListener.updateTrackerIgnoringTrackerClosedException(this.safeTimeTracker, safeTimestamp);
                    }
                    PartitionListener.updateTrackerIgnoringTrackerClosedException(this.storageIndexTracker, commandIndex);
                }
            }
            catch (Throwable t) {
                LOG.error("Got error while processing command [commandIndex={}, commandTerm={}, command={}]", t, new Object[]{clo.index(), clo.index(), command});
                clo.result((Serializable)t);
                throw t;
            }
            finally {
                this.storage.releasePartitionSnapshotsReadLock();
            }
            clo.result((Serializable)result.get1());
        });
    }

    private final void updateTrackers(@Nullable HybridTimestamp safeTs, long commandIndex) {
        if (safeTs != null) {
            PartitionListener.updateTrackerIgnoringTrackerClosedException(this.safeTimeTracker, safeTs);
        }
        PartitionListener.updateTrackerIgnoringTrackerClosedException(this.storageIndexTracker, commandIndex);
    }

    private IgniteBiTuple<Serializable, Boolean> handleUpdateCommand(UpdateCommand cmd, long commandIndex, long commandTerm, HybridTimestamp safeTimestamp) {
        long storageLeaseStartTime;
        long leaseStartTime;
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return new IgniteBiTuple(null, (Object)false);
        }
        if (cmd.leaseStartTime() != null && (leaseStartTime = cmd.leaseStartTime().longValue()) != (storageLeaseStartTime = this.storage.leaseStartTime())) {
            return new IgniteBiTuple((Object)new UpdateCommandResult(false, Long.valueOf(storageLeaseStartTime), this.isPrimaryInGroupTopology(), 0L), (Object)false);
        }
        UUID txId = cmd.txId();
        assert (this.storage.primaryReplicaNodeId() != null);
        assert (this.localNodeId != null);
        if (cmd.full() || !this.localNodeId.equals(this.storage.primaryReplicaNodeId())) {
            this.storageUpdateHandler.handleUpdate(txId, cmd.rowUuid(), cmd.tablePartitionId().asTablePartitionId(), cmd.rowToUpdate(), !cmd.full(), () -> this.storage.lastApplied(commandIndex, commandTerm), (HybridTimestamp)(cmd.full() ? safeTimestamp : null), cmd.lastCommitTimestamp(), TableUtils.indexIdsAtRwTxBeginTs(this.catalogService, txId, this.storage.tableId()));
        } else {
            this.advanceLastAppliedIndexConsistently(commandIndex, commandTerm);
        }
        this.replicaTouch(txId, cmd.txCoordinatorId(), (HybridTimestamp)(cmd.full() ? safeTimestamp : null), cmd.full());
        return new IgniteBiTuple((Object)new UpdateCommandResult(true, this.isPrimaryInGroupTopology(), safeTimestamp.longValue()), (Object)true);
    }

    private IgniteBiTuple<Serializable, Boolean> handleUpdateAllCommand(UpdateAllCommand cmd, long commandIndex, long commandTerm, HybridTimestamp safeTimestamp) {
        long storageLeaseStartTime;
        long leaseStartTime;
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return new IgniteBiTuple(null, (Object)false);
        }
        if (cmd.leaseStartTime() != null && (leaseStartTime = cmd.leaseStartTime().longValue()) != (storageLeaseStartTime = this.storage.leaseStartTime())) {
            return new IgniteBiTuple((Object)new UpdateCommandResult(false, Long.valueOf(storageLeaseStartTime), this.isPrimaryInGroupTopology(), 0L), (Object)false);
        }
        UUID txId = cmd.txId();
        if (cmd.full() || !this.localNodeId.equals(this.storage.primaryReplicaNodeId())) {
            this.storageUpdateHandler.handleUpdateAll(txId, cmd.rowsToUpdate(), cmd.tablePartitionId().asTablePartitionId(), !cmd.full(), () -> this.storage.lastApplied(commandIndex, commandTerm), (HybridTimestamp)(cmd.full() ? safeTimestamp : null), TableUtils.indexIdsAtRwTxBeginTs(this.catalogService, txId, this.storage.tableId()));
        } else {
            this.advanceLastAppliedIndexConsistently(commandIndex, commandTerm);
        }
        this.replicaTouch(txId, cmd.txCoordinatorId(), (HybridTimestamp)(cmd.full() ? safeTimestamp : null), cmd.full());
        return new IgniteBiTuple((Object)new UpdateCommandResult(true, this.isPrimaryInGroupTopology(), safeTimestamp.longValue()), (Object)true);
    }

    private IgniteBiTuple<Serializable, Boolean> handleFinishTxCommand(FinishTxCommand cmd, long commandIndex, long commandTerm) throws IgniteInternalException {
        if (commandIndex <= this.txStateStorage.lastAppliedIndex()) {
            return new IgniteBiTuple(null, (Object)false);
        }
        UUID txId = cmd.txId();
        TxState stateToSet = cmd.commit() ? TxState.COMMITTED : TxState.ABORTED;
        TxMeta txMetaToSet = new TxMeta(stateToSet, PartitionListener.fromPartitionIdMessage(cmd.partitionIds()), cmd.commitTimestamp());
        TxMeta txMetaBeforeCas = this.txStateStorage.get(txId);
        boolean txStateChangeRes = this.txStateStorage.compareAndSet(txId, null, txMetaToSet, commandIndex, commandTerm);
        TablePartitionId commitPartitionId = new TablePartitionId(this.storage.tableId(), this.storage.partitionId());
        this.markFinished(txId, cmd.commit(), cmd.commitTimestamp(), commitPartitionId);
        LOG.debug("Finish the transaction txId = {}, state = {}, txStateChangeRes = {}", new Object[]{txId, txMetaToSet, txStateChangeRes});
        if (!txStateChangeRes) {
            PartitionListener.onTxStateStorageCasFail(txId, txMetaBeforeCas, txMetaToSet);
        }
        return new IgniteBiTuple((Object)new TransactionResult(stateToSet, cmd.commitTimestamp()), (Object)true);
    }

    private static List<TablePartitionId> fromPartitionIdMessage(List<TablePartitionIdMessage> partitionIds) {
        ArrayList<TablePartitionId> list = new ArrayList<TablePartitionId>(partitionIds.size());
        for (TablePartitionIdMessage partitionIdMessage : partitionIds) {
            list.add(partitionIdMessage.asTablePartitionId());
        }
        return list;
    }

    private IgniteBiTuple<Serializable, Boolean> handleWriteIntentSwitchCommand(WriteIntentSwitchCommand cmd, long commandIndex, long commandTerm) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return new IgniteBiTuple(null, (Object)false);
        }
        UUID txId = cmd.txId();
        this.markFinished(txId, cmd.commit(), cmd.commitTimestamp(), null);
        this.storageUpdateHandler.switchWriteIntents(txId, cmd.commit(), cmd.commitTimestamp(), () -> this.storage.lastApplied(commandIndex, commandTerm), TableUtils.indexIdsAtRwTxBeginTs(this.catalogService, txId, this.storage.tableId()));
        return new IgniteBiTuple(null, (Object)true);
    }

    private IgniteBiTuple<Serializable, Boolean> handleSafeTimeSyncCommand(SafeTimeSyncCommand cmd, long commandIndex, long commandTerm) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return new IgniteBiTuple(null, (Object)false);
        }
        this.advanceLastAppliedIndexConsistently(commandIndex, commandTerm);
        return new IgniteBiTuple(null, (Object)true);
    }

    private void advanceLastAppliedIndexConsistently(long commandIndex, long commandTerm) {
        this.storage.runConsistently(locker -> {
            this.storage.lastApplied(commandIndex, commandTerm);
            return null;
        });
    }

    public void onConfigurationCommitted(CommittedConfiguration config) {
        this.currentGroupTopology = new HashSet<String>(config.peers());
        this.currentGroupTopology.addAll(config.learners());
        if (config.index() <= this.storage.lastAppliedIndex()) {
            return;
        }
        this.storage.acquirePartitionSnapshotsReadLock();
        try {
            this.storage.runConsistently(locker -> {
                this.storage.committedGroupConfiguration(RaftGroupConfiguration.fromCommittedConfiguration((CommittedConfiguration)config));
                this.storage.lastApplied(config.index(), config.term());
                PartitionListener.updateTrackerIgnoringTrackerClosedException(this.storageIndexTracker, config.index());
                return null;
            });
        }
        finally {
            this.storage.releasePartitionSnapshotsReadLock();
        }
    }

    public void onSnapshotSave(Path path, Consumer<Throwable> doneClo) {
        long maxLastAppliedIndex = Math.max(this.storage.lastAppliedIndex(), this.txStateStorage.lastAppliedIndex());
        long maxLastAppliedTerm = Math.max(this.storage.lastAppliedTerm(), this.txStateStorage.lastAppliedTerm());
        this.storage.runConsistently(locker -> {
            this.storage.lastApplied(maxLastAppliedIndex, maxLastAppliedTerm);
            return null;
        });
        this.txStateStorage.lastApplied(maxLastAppliedIndex, maxLastAppliedTerm);
        PartitionListener.updateTrackerIgnoringTrackerClosedException(this.storageIndexTracker, maxLastAppliedIndex);
        CompletableFuture.allOf(this.storage.flush(), this.txStateStorage.flush()).whenComplete((unused, throwable) -> doneClo.accept((Throwable)throwable));
    }

    public boolean onSnapshotLoad(Path path) {
        return true;
    }

    public void onShutdown() {
        this.storage.close();
    }

    public void onLeaderStop() {
    }

    @TestOnly
    public MvPartitionStorage getMvStorage() {
        return this.storage.getStorage();
    }

    @TestOnly
    public PendingComparableValuesTracker<HybridTimestamp, Void> getSafeTimeTracker() {
        return this.safeTimeTracker;
    }

    IgniteBiTuple<Serializable, Boolean> handleBuildIndexCommand(BuildIndexCommand cmd, long commandIndex, long commandTerm) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return new IgniteBiTuple(null, (Object)false);
        }
        IndexMeta indexMeta = this.indexMetaStorage.indexMeta(cmd.indexId());
        if (indexMeta == null || indexMeta.isDropped()) {
            return new IgniteBiTuple(null, (Object)true);
        }
        BuildIndexRowVersionChooser rowVersionChooser = this.createBuildIndexRowVersionChooser(indexMeta);
        BinaryRowUpgrader binaryRowUpgrader = this.createBinaryRowUpgrader(indexMeta);
        this.storage.runConsistently(locker -> {
            ArrayList<UUID> rowUuids = new ArrayList<UUID>(cmd.rowIds());
            Collections.sort(rowUuids);
            Stream<BinaryRowAndRowId> buildIndexRowStream = this.createBuildIndexRowStream(rowUuids, locker, rowVersionChooser, binaryRowUpgrader);
            RowId nextRowIdToBuild = cmd.finish() ? null : this.toRowId(Objects.requireNonNull((UUID)CollectionUtils.last(rowUuids))).increment();
            this.storageUpdateHandler.getIndexUpdateHandler().buildIndex(cmd.indexId(), buildIndexRowStream, nextRowIdToBuild);
            this.storage.lastApplied(commandIndex, commandTerm);
            return null;
        });
        if (cmd.finish()) {
            LOG.info("Finish building the index: [tableId={}, partitionId={}, indexId={}]", new Object[]{this.storage.tableId(), this.storage.partitionId(), cmd.indexId()});
        }
        return new IgniteBiTuple(null, (Object)true);
    }

    private IgniteBiTuple<Serializable, Boolean> handlePrimaryReplicaChangeCommand(PrimaryReplicaChangeCommand cmd, long commandIndex, long commandTerm) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return new IgniteBiTuple(null, (Object)false);
        }
        this.storage.runConsistently(locker -> {
            this.storage.updateLease(cmd.leaseStartTime(), cmd.primaryReplicaNodeId(), cmd.primaryReplicaNodeName());
            this.storage.lastApplied(commandIndex, commandTerm);
            return null;
        });
        return new IgniteBiTuple(null, (Object)true);
    }

    private IgniteBiTuple<Serializable, Boolean> handleVacuumTxStatesCommand(VacuumTxStatesCommand cmd, long commandIndex, long commandTerm) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return new IgniteBiTuple(null, (Object)false);
        }
        this.txStateStorage.removeAll((Collection)cmd.txIds(), commandIndex, commandTerm);
        return new IgniteBiTuple(null, (Object)true);
    }

    private IgniteBiTuple<Serializable, Boolean> handleUpdateMinimalActiveTxTimeCommand(UpdateMinimumActiveTxBeginTimeCommand cmd, long commandIndex, long commandTerm) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return new IgniteBiTuple(null, (Object)false);
        }
        long timestamp = cmd.timestamp();
        this.storage.flush(false).whenComplete((r, t) -> {
            if (t == null) {
                TablePartitionId partitionId = new TablePartitionId(this.storage.tableId(), this.storage.partitionId());
                this.minTimeCollectorService.recordMinActiveTxTimestamp(partitionId, timestamp);
            }
        });
        return new IgniteBiTuple(null, (Object)true);
    }

    private static void onTxStateStorageCasFail(UUID txId, TxMeta txMetaBeforeCas, TxMeta txMetaToSet) {
        String errorMsg = IgniteStringFormatter.format((String)"Failed to update tx state in the storage, transaction txId = {} because of inconsistent state, expected state = {}, state to set = {}", (Object[])new Object[]{txId, txMetaBeforeCas, txMetaToSet});
        UnexpectedTransactionStateException stateChangeException = new UnexpectedTransactionStateException(errorMsg, new TransactionResult(txMetaBeforeCas.txState(), txMetaBeforeCas.commitTimestamp()));
        LOG.error(errorMsg, new Object[0]);
        throw stateChangeException;
    }

    private static <T extends Comparable<T>> void updateTrackerIgnoringTrackerClosedException(PendingComparableValuesTracker<T, Void> tracker, T newValue) {
        try {
            tracker.update(newValue, null);
        }
        catch (TrackerClosedException trackerClosedException) {
            // empty catch block
        }
    }

    private Stream<BinaryRowAndRowId> createBuildIndexRowStream(List<UUID> rowUuids, MvPartitionStorage.Locker locker, BuildIndexRowVersionChooser rowVersionChooser, BinaryRowUpgrader binaryRowUpgrader) {
        return rowUuids.stream().map(this::toRowId).peek(arg_0 -> ((MvPartitionStorage.Locker)locker).lock(arg_0)).map(rowVersionChooser::chooseForBuildIndex).flatMap(Collection::stream).map(binaryRowAndRowId -> PartitionListener.upgradeBinaryRow(binaryRowUpgrader, binaryRowAndRowId));
    }

    private RowId toRowId(UUID rowUuid) {
        return new RowId(this.storageUpdateHandler.partitionId(), rowUuid);
    }

    private void replicaTouch(UUID txId, UUID txCoordinatorId, HybridTimestamp commitTimestamp, boolean full) {
        this.txManager.updateTxMeta(txId, old -> new TxStateMeta(full ? TxState.COMMITTED : TxState.PENDING, txCoordinatorId, old == null ? null : old.commitPartitionId(), (HybridTimestamp)(full ? commitTimestamp : null)));
    }

    private void markFinished(UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp, @Nullable TablePartitionId partId) {
        this.txManager.updateTxMeta(txId, old -> new TxStateMeta(commit ? TxState.COMMITTED : TxState.ABORTED, old == null ? null : old.txCoordinatorId(), old == null ? partId : old.commitPartitionId(), (HybridTimestamp)(commit ? commitTimestamp : null), old == null ? null : old.initialVacuumObservationTimestamp(), old == null ? null : old.cleanupCompletionTimestamp()));
    }

    private BuildIndexRowVersionChooser createBuildIndexRowVersionChooser(IndexMeta indexMeta) {
        MetaIndexStatusChange registeredChangeInfo = indexMeta.statusChange(MetaIndexStatus.REGISTERED);
        MetaIndexStatusChange buildingChangeInfo = indexMeta.statusChange(MetaIndexStatus.BUILDING);
        return new BuildIndexRowVersionChooser(this.storage, registeredChangeInfo.activationTimestamp(), buildingChangeInfo.activationTimestamp());
    }

    private BinaryRowUpgrader createBinaryRowUpgrader(IndexMeta indexMeta) {
        SchemaDescriptor schema = this.schemaRegistry.schema(indexMeta.tableVersion());
        return new BinaryRowUpgrader(this.schemaRegistry, schema);
    }

    private static BinaryRowAndRowId upgradeBinaryRow(BinaryRowUpgrader upgrader, BinaryRowAndRowId source) {
        BinaryRow sourceBinaryRow = source.binaryRow();
        BinaryRow upgradedBinaryRow = upgrader.upgrade(sourceBinaryRow);
        return upgradedBinaryRow == sourceBinaryRow ? source : new BinaryRowAndRowId(upgradedBinaryRow, source.rowId());
    }

    private boolean isPrimaryInGroupTopology() {
        assert (this.currentGroupTopology != null) : "Current group topology is null";
        if (this.storage.primaryReplicaNodeName() == null) {
            return true;
        }
        assert (this.storage.primaryReplicaNodeName() != null) : "Primary replica node name is null.";
        return this.currentGroupTopology.contains(this.storage.primaryReplicaNodeName());
    }
}

