/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMeta;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMetaRequest;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMetaResponse;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataRequest;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponse;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotTxDataRequest;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotTxDataResponse;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowMessage;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionAccess;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionKey;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.SnapshotMetaUtils;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxMetaMessage;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.raft.jraft.util.concurrent.ConcurrentHashSet;
import org.jetbrains.annotations.Nullable;

public class OutgoingSnapshot {
    private static final IgniteLogger LOG = Loggers.forClass(OutgoingSnapshot.class);
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private final UUID id;
    private final PartitionAccess partition;
    private final CatalogService catalogService;
    private final ReentrantLock mvOperationsLock = new ReentrantLock();
    @Nullable
    private volatile PartitionSnapshotMeta frozenMeta;
    private final Set<RowId> rowIdsToSkip = new ConcurrentHashSet();
    private final Queue<SnapshotMvDataResponse.ResponseEntry> outOfOrderMvData = new ArrayDeque<SnapshotMvDataResponse.ResponseEntry>();
    private RowId lastRowId;
    private boolean startedToReadMvPartition = false;
    private Cursor<IgniteBiTuple<UUID, TxMeta>> txDataCursor;
    private boolean finishedTxData = false;
    private volatile boolean closed = false;

    public OutgoingSnapshot(UUID id, PartitionAccess partition, CatalogService catalogService) {
        this.id = id;
        this.partition = partition;
        this.catalogService = catalogService;
        this.lastRowId = RowId.lowestRowId((int)partition.partitionKey().partitionId());
    }

    public UUID id() {
        return this.id;
    }

    public PartitionKey partitionKey() {
        return this.partition.partitionKey();
    }

    void freezeScopeUnderMvLock() {
        this.acquireMvLock();
        try {
            this.frozenMeta = this.takeSnapshotMeta();
            this.txDataCursor = this.partition.getAllTxMeta();
        }
        finally {
            this.releaseMvLock();
        }
    }

    private PartitionSnapshotMeta takeSnapshotMeta() {
        RaftGroupConfiguration config = this.partition.committedGroupConfiguration();
        assert (config != null) : "Configuration should never be null when installing a snapshot";
        int catalogVersion = this.catalogService.latestCatalogVersion();
        Map<Integer, UUID> nextRowIdToBuildByIndexId = SnapshotMetaUtils.collectNextRowIdToBuildIndexes(this.catalogService, this.partition, catalogVersion);
        return SnapshotMetaUtils.snapshotMetaAt(this.partition.maxLastAppliedIndex(), this.partition.maxLastAppliedTerm(), config, catalogVersion, nextRowIdToBuildByIndexId, this.partition.leaseStartTime(), this.partition.primaryReplicaNodeId(), this.partition.primaryReplicaNodeName());
    }

    public PartitionSnapshotMeta meta() {
        PartitionSnapshotMeta meta = this.frozenMeta;
        assert (meta != null) : "No snapshot meta yet, probably the snapshot scope was not yet frozen";
        return meta;
    }

    @Nullable
    SnapshotMetaResponse handleSnapshotMetaRequest(SnapshotMetaRequest request) {
        assert (Objects.equals(request.id(), this.id)) : "Expected id " + String.valueOf(this.id) + " but got " + String.valueOf(request.id());
        if (this.closed) {
            return (SnapshotMetaResponse)this.logThatAlreadyClosedAndReturnNull();
        }
        PartitionSnapshotMeta meta = this.frozenMeta;
        assert (meta != null) : "No snapshot meta yet, probably the snapshot scope was not yet frozen";
        return PARTITION_REPLICATION_MESSAGES_FACTORY.snapshotMetaResponse().meta(meta).build();
    }

    @Nullable
    private <T> T logThatAlreadyClosedAndReturnNull() {
        LOG.debug("Snapshot with ID '{}' is already closed", new Object[]{this.id});
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    SnapshotMvDataResponse handleSnapshotMvDataRequest(SnapshotMvDataRequest request) {
        if (this.closed) {
            return (SnapshotMvDataResponse)this.logThatAlreadyClosedAndReturnNull();
        }
        assert (!this.finishedMvData()) : "MV data sending has already been finished";
        long totalBatchSize = 0L;
        ArrayList<SnapshotMvDataResponse.ResponseEntry> batch = new ArrayList<SnapshotMvDataResponse.ResponseEntry>();
        while (true) {
            this.acquireMvLock();
            try {
                totalBatchSize = this.fillWithOutOfOrderRows(batch, totalBatchSize, request);
                totalBatchSize = this.tryProcessRowFromPartition(batch, totalBatchSize, request);
                if (!this.finishedMvData() && !OutgoingSnapshot.batchIsFull(request, totalBatchSize)) continue;
            }
            finally {
                this.releaseMvLock();
                continue;
            }
            break;
        }
        return PARTITION_REPLICATION_MESSAGES_FACTORY.snapshotMvDataResponse().rows(batch).finish(this.finishedMvData()).build();
    }

    private long fillWithOutOfOrderRows(List<SnapshotMvDataResponse.ResponseEntry> rowEntries, long totalBytesBefore, SnapshotMvDataRequest request) {
        long totalBytesAfter;
        SnapshotMvDataResponse.ResponseEntry rowEntry;
        assert (this.mvOperationsLock.isLocked()) : "MV operations lock must be acquired!";
        for (totalBytesAfter = totalBytesBefore; totalBytesAfter < request.batchSizeHint() && (rowEntry = this.outOfOrderMvData.poll()) != null; totalBytesAfter += OutgoingSnapshot.rowSizeInBytes(rowEntry.rowVersions())) {
            rowEntries.add(rowEntry);
        }
        return totalBytesAfter;
    }

    private static long rowSizeInBytes(List<BinaryRowMessage> rowVersions) {
        long sum = 0L;
        for (BinaryRowMessage rowMessage : rowVersions) {
            if (rowMessage == null) continue;
            sum += (long)(rowMessage.binaryTuple().remaining() + 2);
        }
        return sum;
    }

    private long tryProcessRowFromPartition(List<SnapshotMvDataResponse.ResponseEntry> batch, long totalBatchSize, SnapshotMvDataRequest request) {
        if (OutgoingSnapshot.batchIsFull(request, totalBatchSize) || this.finishedMvData()) {
            return totalBatchSize;
        }
        if (!this.startedToReadMvPartition) {
            this.lastRowId = this.partition.closestRowId(this.lastRowId);
            this.startedToReadMvPartition = true;
        } else {
            this.lastRowId = this.partition.closestRowId(this.lastRowId.increment());
        }
        if (!this.finishedMvData() && !this.rowIdsToSkip.remove(this.lastRowId)) {
            SnapshotMvDataResponse.ResponseEntry rowEntry = this.rowEntry(this.lastRowId);
            assert (rowEntry != null);
            batch.add(rowEntry);
            totalBatchSize += OutgoingSnapshot.rowSizeInBytes(rowEntry.rowVersions());
        }
        return totalBatchSize;
    }

    private static boolean batchIsFull(SnapshotMvDataRequest request, long totalBatchSize) {
        return totalBatchSize >= request.batchSizeHint();
    }

    @Nullable
    private SnapshotMvDataResponse.ResponseEntry rowEntry(RowId rowId) {
        List<ReadResult> rowVersionsN2O = this.partition.getAllRowVersions(rowId);
        if (rowVersionsN2O.isEmpty()) {
            return null;
        }
        int count = rowVersionsN2O.size();
        ArrayList<BinaryRowMessage> rowVersions = new ArrayList<BinaryRowMessage>(count);
        int commitTimestampsCount = rowVersionsN2O.get(0).isWriteIntent() ? count - 1 : count;
        long[] commitTimestamps = new long[commitTimestampsCount];
        UUID transactionId = null;
        Integer commitTableId = null;
        int commitPartitionId = -1;
        int j = 0;
        for (int i = count - 1; i >= 0; --i) {
            ReadResult version = rowVersionsN2O.get(i);
            BinaryRow row = version.binaryRow();
            BinaryRowMessage rowMessage = row == null ? null : PARTITION_REPLICATION_MESSAGES_FACTORY.binaryRowMessage().binaryTuple(row.tupleSlice()).schemaVersion(row.schemaVersion()).build();
            rowVersions.add(rowMessage);
            if (version.isWriteIntent()) {
                assert (i == 0) : rowVersionsN2O;
                transactionId = version.transactionId();
                commitTableId = version.commitTableId();
                commitPartitionId = version.commitPartitionId();
                continue;
            }
            commitTimestamps[j++] = version.commitTimestamp().longValue();
        }
        return PARTITION_REPLICATION_MESSAGES_FACTORY.responseEntry().rowId(rowId.uuid()).rowVersions(rowVersions).timestamps(commitTimestamps).txId(transactionId).commitTableId(commitTableId).commitPartitionId(commitPartitionId).build();
    }

    @Nullable
    SnapshotTxDataResponse handleSnapshotTxDataRequest(SnapshotTxDataRequest request) {
        if (this.closed) {
            return (SnapshotTxDataResponse)this.logThatAlreadyClosedAndReturnNull();
        }
        ArrayList<IgniteBiTuple<UUID, TxMeta>> rows = new ArrayList<IgniteBiTuple<UUID, TxMeta>>();
        while (!this.finishedTxData && rows.size() < request.maxTransactionsInBatch()) {
            if (this.txDataCursor.hasNext()) {
                rows.add((IgniteBiTuple<UUID, TxMeta>)((IgniteBiTuple)this.txDataCursor.next()));
                continue;
            }
            this.finishedTxData = true;
            OutgoingSnapshot.closeLoggingProblems(this.txDataCursor);
        }
        return OutgoingSnapshot.buildTxDataResponse(rows, this.finishedTxData);
    }

    private static void closeLoggingProblems(Cursor<?> cursor) {
        try {
            cursor.close();
        }
        catch (RuntimeException e) {
            LOG.error("Problem while closing a cursor", (Throwable)e);
        }
    }

    private static SnapshotTxDataResponse buildTxDataResponse(List<IgniteBiTuple<UUID, TxMeta>> rows, boolean finished) {
        ArrayList<UUID> txIds = new ArrayList<UUID>(rows.size());
        ArrayList<TxMetaMessage> txMetas = new ArrayList<TxMetaMessage>(rows.size());
        for (IgniteBiTuple<UUID, TxMeta> row : rows) {
            txIds.add((UUID)row.getKey());
            txMetas.add(((TxMeta)row.getValue()).toTransactionMetaMessage(REPLICA_MESSAGES_FACTORY, TX_MESSAGES_FACTORY));
        }
        return PARTITION_REPLICATION_MESSAGES_FACTORY.snapshotTxDataResponse().txIds(txIds).txMeta(txMetas).finish(finished).build();
    }

    public void acquireMvLock() {
        this.mvOperationsLock.lock();
    }

    public void releaseMvLock() {
        this.mvOperationsLock.unlock();
    }

    private boolean finishedMvData() {
        return this.lastRowId == null;
    }

    public boolean addRowIdToSkip(RowId rowId) {
        assert (this.mvOperationsLock.isLocked()) : "MV operations lock must be acquired!";
        return this.rowIdsToSkip.add(rowId);
    }

    public boolean alreadyPassed(RowId rowId) {
        assert (this.mvOperationsLock.isLocked()) : "MV operations lock must be acquired!";
        if (!this.startedToReadMvPartition) {
            return false;
        }
        if (this.finishedMvData()) {
            return true;
        }
        return rowId.compareTo(this.lastRowId) <= 0;
    }

    public void enqueueForSending(RowId rowId) {
        assert (this.mvOperationsLock.isLocked()) : "MV operations lock must be acquired!";
        SnapshotMvDataResponse.ResponseEntry entry = this.rowEntry(rowId);
        if (entry != null) {
            this.outOfOrderMvData.add(entry);
        }
    }

    public void close() {
        Cursor<IgniteBiTuple<UUID, TxMeta>> txCursor = this.txDataCursor;
        if (txCursor != null) {
            OutgoingSnapshot.closeLoggingProblems(txCursor);
        }
        this.closed = true;
    }
}

