/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replicator;

import org.jetbrains.annotations.Nullable;

public class CompatValidationResult {
    private static final CompatValidationResult SUCCESSFUL_RESULT = new CompatValidationResult(ValidationStatus.SUCCESS, "", -1, -1, null);
    private final ValidationStatus status;
    private final String failedTableName;
    private final int fromSchemaVersion;
    @Nullable
    private final Integer toSchemaVersion;
    @Nullable
    private final String details;

    public static CompatValidationResult success() {
        return SUCCESSFUL_RESULT;
    }

    public static CompatValidationResult incompatibleChange(String failedTableName, int fromSchemaVersion, int toSchemaVersion, @Nullable String details) {
        return new CompatValidationResult(ValidationStatus.INCOMPATIBLE_CHANGE, failedTableName, fromSchemaVersion, toSchemaVersion, details);
    }

    public static CompatValidationResult tableDropped(String failedTableName, int fromSchemaVersion) {
        return new CompatValidationResult(ValidationStatus.TABLE_DROPPED, failedTableName, fromSchemaVersion, null, null);
    }

    private CompatValidationResult(ValidationStatus status, String failedTableName, int fromSchemaVersion, @Nullable Integer toSchemaVersion, @Nullable String details) {
        this.status = status;
        this.failedTableName = failedTableName;
        this.fromSchemaVersion = fromSchemaVersion;
        this.toSchemaVersion = toSchemaVersion;
        this.details = details;
    }

    public boolean isSuccessful() {
        return this.status == ValidationStatus.SUCCESS;
    }

    public boolean isTableDropped() {
        return this.status == ValidationStatus.TABLE_DROPPED;
    }

    public String failedTableName() {
        assert (!this.isSuccessful()) : "Should not be called on a successful result";
        return this.failedTableName;
    }

    public int fromSchemaVersion() {
        assert (!this.isSuccessful()) : "Should not be called on a successful result";
        return this.fromSchemaVersion;
    }

    public int toSchemaVersion() {
        assert (!this.isSuccessful()) : "Should not be called on a successful result";
        assert (this.toSchemaVersion != null) : "Should not be called when there is no toSchemaVersion";
        return this.toSchemaVersion;
    }

    public String details() {
        assert (!this.isSuccessful()) : "Should not be called on a successful result";
        assert (this.details != null) : "Should not be called when there are no details";
        return this.details;
    }

    private static enum ValidationStatus {
        SUCCESS,
        INCOMPATIBLE_CHANGE,
        TABLE_DROPPED;

    }
}

