/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.partition;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.partition.Partition;
import org.apache.ignite.table.partition.PartitionManager;

public class PublicApiThreadingPartitionManager
implements PartitionManager {
    private final PartitionManager partitionManager;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingPartitionManager(PartitionManager partitionManager, Executor asyncContinuationExecutor) {
        this.partitionManager = partitionManager;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public CompletableFuture<ClusterNode> primaryReplicaAsync(Partition partition) {
        return this.preventThreadHijack(this.partitionManager.primaryReplicaAsync(partition));
    }

    public CompletableFuture<Map<Partition, ClusterNode>> primaryReplicasAsync() {
        return this.preventThreadHijack(this.partitionManager.primaryReplicasAsync());
    }

    public <K> CompletableFuture<Partition> partitionAsync(K key, Mapper<K> mapper) {
        return this.preventThreadHijack(this.partitionManager.partitionAsync(key, mapper));
    }

    public CompletableFuture<Partition> partitionAsync(Tuple key) {
        return this.preventThreadHijack(this.partitionManager.partitionAsync(key));
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, (Executor)this.asyncContinuationExecutor);
    }
}

