/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PartitionMeta;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.pagememory.util.PageLockListenerNoOp;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.storage.pagememory.AbstractPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.StoragePartitionMeta;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.PersistentPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public class PersistentPageMemoryTableStorage
extends AbstractPageMemoryTableStorage {
    private final PersistentPageMemoryStorageEngine engine;
    private final PersistentPageMemoryDataRegion dataRegion;
    private final ExecutorService destructionExecutor;

    PersistentPageMemoryTableStorage(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier, PersistentPageMemoryStorageEngine engine, PersistentPageMemoryDataRegion dataRegion, ExecutorService destructionExecutor) {
        super(tableDescriptor, indexDescriptorSupplier);
        this.engine = engine;
        this.dataRegion = dataRegion;
        this.destructionExecutor = destructionExecutor;
    }

    @Override
    public PersistentPageMemoryStorageEngine engine() {
        return this.engine;
    }

    public PersistentPageMemoryDataRegion dataRegion() {
        return this.dataRegion;
    }

    public boolean isVolatile() {
        return false;
    }

    @Override
    protected void finishDestruction() {
        this.dataRegion.pageMemory().onGroupDestroyed(this.getTableId());
    }

    @Override
    public PersistentPageMemoryMvPartitionStorage createMvPartitionStorage(int partitionId) {
        GroupPartitionId groupPartitionId = this.createGroupPartitionId(partitionId);
        StoragePartitionMeta meta = this.getOrCreatePartitionMetaOnCreatePartition(groupPartitionId);
        return this.inCheckpointLock(() -> {
            PersistentPageMemory pageMemory = this.dataRegion.pageMemory();
            FreeListImpl freeList = this.createFreeList(partitionId, pageMemory, meta);
            VersionChainTree versionChainTree = this.createVersionChainTree(partitionId, (ReuseList)freeList, pageMemory, meta);
            IndexMetaTree indexMetaTree = this.createIndexMetaTree(partitionId, (ReuseList)freeList, pageMemory, meta);
            GcQueue gcQueue = this.createGcQueue(partitionId, (ReuseList)freeList, pageMemory, meta);
            return new PersistentPageMemoryMvPartitionStorage(this, partitionId, meta, freeList, versionChainTree, indexMetaTree, gcQueue, this.destructionExecutor);
        });
    }

    @Nullable
    public UUID lastCheckpointId() {
        CheckpointProgress lastCeckpointProgress = this.dataRegion.checkpointManager().lastCheckpointProgress();
        return lastCeckpointProgress == null ? null : lastCeckpointProgress.id();
    }

    private FreeListImpl createFreeList(int partId, PersistentPageMemory pageMemory, StoragePartitionMeta meta) throws StorageException {
        try {
            boolean initNew = false;
            if (meta.freeListRootPageId() == 0L) {
                long rootPageId = pageMemory.allocatePageNoReuse(this.getTableId(), partId, (byte)2);
                meta.freeListRootPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new FreeListImpl("PersistentFreeList", this.getTableId(), partId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, meta.freeListRootPageId(), initNew, this.dataRegion.pageListCacheLimit(), (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating free list: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{this.getTableId(), partId});
        }
    }

    private VersionChainTree createVersionChainTree(int partId, ReuseList reuseList, PersistentPageMemory pageMemory, StoragePartitionMeta meta) throws StorageException {
        try {
            boolean initNew = false;
            if (meta.versionChainTreeRootPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(reuseList, this.getTableId(), partId, (byte)2);
                meta.versionChainTreeRootPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new VersionChainTree(this.getTableId(), Integer.toString(this.getTableId()), partId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, this.engine.generateGlobalRemoveId(), meta.versionChainTreeRootPageId(), reuseList, initNew);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating VersionChainTree: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{this.getTableId(), partId});
        }
    }

    private IndexMetaTree createIndexMetaTree(int partitionId, ReuseList reuseList, PersistentPageMemory pageMemory, StoragePartitionMeta meta) {
        try {
            boolean initNew = false;
            if (meta.indexTreeMetaPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(reuseList, this.getTableId(), partitionId, (byte)2);
                meta.indexTreeMetaPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new IndexMetaTree(this.getTableId(), Integer.toString(this.getTableId()), partitionId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, this.engine.generateGlobalRemoveId(), meta.indexTreeMetaPageId(), reuseList, initNew);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating IndexMetaTree: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{this.getTableId(), partitionId});
        }
    }

    private GcQueue createGcQueue(int partitionId, ReuseList reuseList, PersistentPageMemory pageMemory, StoragePartitionMeta meta) {
        try {
            boolean initNew = false;
            if (meta.gcQueueMetaPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(reuseList, this.getTableId(), partitionId, (byte)2);
                meta.gcQueueMetaPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new GcQueue(this.getTableId(), Integer.toString(this.getTableId()), partitionId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, this.engine.generateGlobalRemoveId(), meta.gcQueueMetaPageId(), reuseList, initNew);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating GarbageCollectionTree: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{this.getTableId(), partitionId});
        }
    }

    @Override
    CompletableFuture<Void> destroyMvPartitionStorage(AbstractPageMemoryMvPartitionStorage mvPartitionStorage) {
        boolean transitioned = mvPartitionStorage.transitionToDestroyedState();
        if (transitioned) {
            mvPartitionStorage.closeResources();
        }
        return this.destroyPartitionPhysically(this.createGroupPartitionId(mvPartitionStorage.partitionId()));
    }

    @Override
    CompletableFuture<Void> clearStorageAndUpdateDataStructures(AbstractPageMemoryMvPartitionStorage mvPartitionStorage) {
        GroupPartitionId groupPartitionId = this.createGroupPartitionId(mvPartitionStorage.partitionId());
        return this.destroyPartitionPhysically(groupPartitionId).thenAccept(unused -> {
            PersistentPageMemory pageMemory = this.dataRegion.pageMemory();
            int partitionId = groupPartitionId.getPartitionId();
            StoragePartitionMeta meta = this.getOrCreatePartitionMetaOnCreatePartition(groupPartitionId);
            this.inCheckpointLock(() -> {
                FreeListImpl freeList = this.createFreeList(partitionId, pageMemory, meta);
                VersionChainTree versionChainTree = this.createVersionChainTree(partitionId, (ReuseList)freeList, pageMemory, meta);
                IndexMetaTree indexMetaTree = this.createIndexMetaTree(partitionId, (ReuseList)freeList, pageMemory, meta);
                GcQueue gcQueue = this.createGcQueue(partitionId, (ReuseList)freeList, pageMemory, meta);
                ((PersistentPageMemoryMvPartitionStorage)mvPartitionStorage).updateDataStructures(meta, freeList, versionChainTree, indexMetaTree, gcQueue);
                return null;
            });
        });
    }

    private CompletableFuture<Void> destroyPartitionPhysically(GroupPartitionId groupPartitionId) {
        this.dataRegion.filePageStoreManager().getStore(groupPartitionId).markToDestroy();
        this.dataRegion.pageMemory().invalidate(groupPartitionId.getGroupId(), groupPartitionId.getPartitionId());
        return ((CompletableFuture)this.dataRegion.checkpointManager().onPartitionDestruction(groupPartitionId).thenAccept(unused -> this.dataRegion.partitionMetaManager().removeMeta(groupPartitionId))).thenCompose(unused -> this.dataRegion.filePageStoreManager().destroyPartition(groupPartitionId));
    }

    private GroupPartitionId createGroupPartitionId(int partitionId) {
        return new GroupPartitionId(this.getTableId(), partitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V inCheckpointLock(Supplier<V> supplier) {
        CheckpointTimeoutLock checkpointTimeoutLock = this.dataRegion.checkpointManager().checkpointTimeoutLock();
        checkpointTimeoutLock.checkpointReadLock();
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            checkpointTimeoutLock.checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoragePartitionMeta getOrCreatePartitionMetaOnCreatePartition(GroupPartitionId groupPartitionId) {
        ByteBuffer buffer = GridUnsafe.allocateBuffer((int)this.dataRegion.pageMemory().pageSize());
        try {
            FilePageStore filePageStore = this.dataRegion.filePageStoreManager().getStore(groupPartitionId);
            if (filePageStore != null) {
                StoragePartitionMeta partitionMeta = (StoragePartitionMeta)this.dataRegion.partitionMetaManager().getMeta(groupPartitionId);
                assert (partitionMeta != null) : groupPartitionId;
                StoragePartitionMeta storagePartitionMeta = partitionMeta;
                return storagePartitionMeta;
            }
            filePageStore = this.readOrCreateAndInitFilePageStore(groupPartitionId, buffer);
            StoragePartitionMeta partitionMeta = this.readOrCreatePartitionMeta(groupPartitionId, filePageStore, buffer.rewind());
            filePageStore.pages(partitionMeta.pageCount());
            filePageStore.setPageAllocationListener(pageIdx -> {
                assert (this.dataRegion.checkpointManager().checkpointTimeoutLock().checkpointLockIsHeldByThread());
                partitionMeta.incrementPageCount(this.lastCheckpointId());
            });
            this.dataRegion.filePageStoreManager().addStore(groupPartitionId, filePageStore);
            this.dataRegion.partitionMetaManager().addMeta(groupPartitionId, (PartitionMeta)partitionMeta);
            if (filePageStore.deltaFileCount() > 0) {
                this.dataRegion.checkpointManager().triggerCompaction();
            }
            StoragePartitionMeta storagePartitionMeta = partitionMeta;
            return storagePartitionMeta;
        }
        finally {
            GridUnsafe.freeBuffer((ByteBuffer)buffer);
        }
    }

    private FilePageStore readOrCreateAndInitFilePageStore(GroupPartitionId groupPartitionId, ByteBuffer buffer) throws StorageException {
        try {
            FilePageStore filePageStore = this.dataRegion.filePageStoreManager().readOrCreateStore(groupPartitionId, buffer);
            assert (!filePageStore.isMarkedToDestroy()) : IgniteStringFormatter.format((String)"Should not be marked for deletion: [tableId={}, partitionId={}]", (Object[])new Object[]{groupPartitionId.getGroupId(), groupPartitionId.getPartitionId()});
            filePageStore.ensure();
            return filePageStore;
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error read and initializing file page store: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{groupPartitionId.getGroupId(), groupPartitionId.getPartitionId()});
        }
    }

    private StoragePartitionMeta readOrCreatePartitionMeta(GroupPartitionId groupPartitionId, FilePageStore filePageStore, ByteBuffer buffer) throws StorageException {
        try {
            return (StoragePartitionMeta)this.dataRegion.partitionMetaManager().readOrCreateMeta(this.lastCheckpointId(), groupPartitionId, filePageStore, buffer);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error reading or creating partition meta information: [tableId={}, partitionId={}]", (Throwable)e, new Object[]{this.getTableId(), groupPartitionId.getPartitionId()});
        }
    }
}

