/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.configuration.schema.VolatilePageMemoryProfileConfiguration;
import org.apache.ignite.internal.pagememory.configuration.schema.VolatilePageMemoryProfileView;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.storage.pagememory.AbstractPageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryStorageEngineConfiguration;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteUtils;

public class VolatilePageMemoryStorageEngine
extends AbstractPageMemoryStorageEngine {
    public static final String ENGINE_NAME = "aimem";
    public static final int MAX_DESTRUCTION_WORK_UNITS = 1000;
    private static final IgniteLogger LOG = Loggers.forClass(VolatilePageMemoryStorageEngine.class);
    private final String igniteInstanceName;
    private final StorageConfiguration storageConfig;
    private final VolatilePageMemoryStorageEngineConfiguration engineConfig;
    private final PageIoRegistry ioRegistry;
    private final Map<String, VolatilePageMemoryDataRegion> regions = new ConcurrentHashMap<String, VolatilePageMemoryDataRegion>();
    private volatile ExecutorService destructionExecutor;

    public VolatilePageMemoryStorageEngine(String igniteInstanceName, VolatilePageMemoryStorageEngineConfiguration engineConfig, StorageConfiguration storageConfig, PageIoRegistry ioRegistry, HybridClock clock) {
        super(clock);
        this.igniteInstanceName = igniteInstanceName;
        this.engineConfig = engineConfig;
        this.storageConfig = storageConfig;
        this.ioRegistry = ioRegistry;
    }

    public String name() {
        return ENGINE_NAME;
    }

    public void start() throws StorageException {
        ((NamedListView)this.storageConfig.profiles().value()).stream().forEach(p -> {
            if (p instanceof VolatilePageMemoryProfileView) {
                this.addDataRegion(p.name());
            }
        });
        ThreadPoolExecutor executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)NamedThreadFactory.create((String)this.igniteInstanceName, (String)"volatile-mv-partition-destruction", (IgniteLogger)LOG));
        executor.allowCoreThreadTimeOut(true);
        this.destructionExecutor = executor;
    }

    public void stop() throws StorageException {
        try {
            Stream<AutoCloseable> closeRegions = this.regions.values().stream().map(region -> region::stop);
            ExecutorService destructionExecutor = this.destructionExecutor;
            Stream<AutoCloseable> shutdownExecutor = Stream.of(destructionExecutor == null ? null : () -> IgniteUtils.shutdownAndAwaitTermination((ExecutorService)destructionExecutor, (long)30L, (TimeUnit)TimeUnit.SECONDS));
            IgniteUtils.closeAll(Stream.concat(shutdownExecutor, closeRegions));
        }
        catch (Exception e) {
            throw new StorageException("Error when stopping components", (Throwable)e);
        }
    }

    public boolean isVolatile() {
        return true;
    }

    public VolatilePageMemoryTableStorage createMvTable(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) throws StorageException {
        VolatilePageMemoryDataRegion dataRegion = this.regions.get(tableDescriptor.getStorageProfile());
        assert (dataRegion != null) : "tableId=" + tableDescriptor.getId() + ", dataRegion=" + tableDescriptor.getStorageProfile();
        return new VolatilePageMemoryTableStorage(tableDescriptor, indexDescriptorSupplier, this, dataRegion, this.destructionExecutor);
    }

    public void dropMvTable(int tableId) {
    }

    private void addDataRegion(String name) {
        VolatilePageMemoryProfileConfiguration storageProfileConfiguration = (VolatilePageMemoryProfileConfiguration)this.storageConfig.profiles().get(name);
        int pageSize = (Integer)this.engineConfig.pageSize().value();
        VolatilePageMemoryDataRegion dataRegion = new VolatilePageMemoryDataRegion(storageProfileConfiguration, this.ioRegistry, pageSize);
        dataRegion.start();
        this.regions.put(name, dataRegion);
    }
}

