/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.ignite.internal.replicator.ReplicationGroupId;

public class ZonePartitionId
implements ReplicationGroupId {
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("_part_");
    private final int zoneId;
    private final int tableId;
    private final int partId;

    public ZonePartitionId(int zoneId, int partId) {
        this.zoneId = zoneId;
        this.partId = partId;
        this.tableId = 0;
    }

    public ZonePartitionId(int zoneId, int tableId, int partId) {
        assert (tableId != 0) : "Use constructor with two parameters.";
        this.zoneId = zoneId;
        this.tableId = tableId;
        this.partId = partId;
    }

    public int zoneId() {
        return this.zoneId;
    }

    public int tableId() {
        return this.tableId;
    }

    public int partitionId() {
        return this.partId;
    }

    public static ZonePartitionId fromString(String str) {
        String[] parts = DELIMITER_PATTERN.split(str);
        return new ZonePartitionId(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    public String toString() {
        return this.zoneId + "_part_" + this.partId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZonePartitionId that = (ZonePartitionId)o;
        return this.zoneId == that.zoneId && this.partId == that.partId && this.tableId == that.tableId;
    }

    public int hashCode() {
        return Objects.hash(this.zoneId, this.partId, this.tableId);
    }
}

