/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.task;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.TaskState;
import org.apache.ignite.compute.task.TaskExecution;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.jetbrains.annotations.Nullable;

public class AntiHijackTaskExecution<R>
implements TaskExecution<R> {
    private final TaskExecution<R> execution;
    private final Executor asyncContinuationExecutor;

    public AntiHijackTaskExecution(TaskExecution<R> execution, Executor asyncContinuationExecutor) {
        this.execution = execution;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public CompletableFuture<List<@Nullable JobState>> statesAsync() {
        return this.preventThreadHijack(this.execution.statesAsync());
    }

    public CompletableFuture<R> resultAsync() {
        return this.preventThreadHijack(this.execution.resultAsync());
    }

    public CompletableFuture<@Nullable TaskState> stateAsync() {
        return this.preventThreadHijack(this.execution.stateAsync());
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.preventThreadHijack(this.execution.changePriorityAsync(newPriority));
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, (Executor)this.asyncContinuationExecutor);
    }
}

