/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.Objects;
import org.apache.ignite.internal.catalog.commands.DefaultValue;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class CatalogTableColumnDescriptor {
    public static final CatalogObjectSerializer<CatalogTableColumnDescriptor> SERIALIZER = new TableColumnDescriptorSerializer();
    private final String name;
    private final ColumnType type;
    private final boolean nullable;
    private final int length;
    private final int precision;
    private final int scale;
    private final DefaultValue defaultValue;

    public CatalogTableColumnDescriptor(String name, ColumnType type, boolean nullable, int precision, int scale, int length, @Nullable DefaultValue defaultValue) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type);
        this.nullable = nullable;
        this.precision = precision;
        this.scale = scale;
        this.length = length;
        this.defaultValue = defaultValue;
    }

    public String name() {
        return this.name;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public ColumnType type() {
        return this.type;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public int length() {
        return this.length;
    }

    @Nullable
    public DefaultValue defaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogTableColumnDescriptor that = (CatalogTableColumnDescriptor)o;
        if (this.nullable != that.nullable) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        if (this.precision != that.precision) {
            return false;
        }
        if (this.scale != that.scale) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.defaultValue != null ? this.defaultValue.equals(that.defaultValue) : that.defaultValue == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.nullable ? 1 : 0);
        result = 31 * result + this.length;
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class TableColumnDescriptorSerializer
    implements CatalogObjectSerializer<CatalogTableColumnDescriptor> {
        private TableColumnDescriptorSerializer() {
        }

        @Override
        public CatalogTableColumnDescriptor readFrom(IgniteDataInput input) throws IOException {
            String name = input.readUTF();
            int typeId = input.readVarIntAsInt();
            ColumnType type = ColumnType.getById((int)typeId);
            assert (type != null) : "Unknown column type: " + typeId;
            boolean nullable = input.readBoolean();
            int precision = input.readVarIntAsInt();
            int scale = input.readVarIntAsInt();
            int length = input.readVarIntAsInt();
            DefaultValue defaultValue = DefaultValue.readFrom(input);
            return new CatalogTableColumnDescriptor(name, type, nullable, precision, scale, length, defaultValue);
        }

        @Override
        public void writeTo(CatalogTableColumnDescriptor descriptor, IgniteDataOutput output) throws IOException {
            output.writeUTF(descriptor.name());
            output.writeVarInt((long)descriptor.type().id());
            output.writeBoolean(descriptor.nullable());
            output.writeVarInt((long)descriptor.precision());
            output.writeVarInt((long)descriptor.scale());
            output.writeVarInt((long)descriptor.length());
            DefaultValue.writeTo(descriptor.defaultValue(), output);
        }
    }
}

