/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import org.treesitter.CleanerRunner;
import org.treesitter.TSNode;
import org.treesitter.TSParser;
import org.treesitter.TSPoint;

public class TSTreeCursor {
    private final long ptr;
    private TSNode node;

    private TSTreeCursor(long ptr) {
        this.ptr = ptr;
        CleanerRunner.register(this, new TSTreeCursorCleanAction(ptr));
    }

    public TSTreeCursor(TSNode node) {
        this(TSParser.ts_tree_cursor_new(node));
        this.node = node;
    }

    public void reset(TSNode node) {
        TSParser.ts_tree_cursor_reset(this.ptr, node);
        this.node = node;
    }

    public TSNode currentNode() {
        TSNode node = TSParser.ts_tree_cursor_current_node(this.ptr);
        node.setTree(this.node.getTree());
        return node;
    }

    public String currentFieldName() {
        return TSParser.ts_tree_cursor_current_field_name(this.ptr);
    }

    public int currentFieldId() {
        return TSParser.ts_tree_cursor_current_field_id(this.ptr);
    }

    public boolean gotoParent() {
        return TSParser.ts_tree_cursor_goto_parent(this.ptr);
    }

    public boolean gotoNextSibling() {
        return TSParser.ts_tree_cursor_goto_next_sibling(this.ptr);
    }

    public boolean gotoFirstChild() {
        return TSParser.ts_tree_cursor_goto_first_child(this.ptr);
    }

    public int gotoFirstChildForByte(int startByte) {
        return TSParser.ts_tree_cursor_goto_first_child_for_byte(this.ptr, startByte);
    }

    public int gotoFirstChildForPoint(TSPoint startPoint) {
        return TSParser.ts_tree_cursor_goto_first_child_for_point(this.ptr, startPoint);
    }

    protected void setNode(TSNode node) {
        this.node = node;
    }

    public TSTreeCursor copy() {
        TSTreeCursor cursor = new TSTreeCursor(TSParser.ts_tree_cursor_copy(this.ptr));
        cursor.setNode(this.node);
        return cursor;
    }

    private static class TSTreeCursorCleanAction
    implements Runnable {
        private final long ptr;

        public TSTreeCursorCleanAction(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void run() {
            TSParser.ts_tree_cursor_delete(this.ptr);
            TSParser.free_cursor(this.ptr);
        }
    }
}

