/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.hlc;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.jetbrains.annotations.Nullable;

public interface HybridTimestampTracker {
    public static final HybridTimestampTracker EMPTY_TS_PROVIDER = new HybridTimestampTracker(){

        @Override
        @Nullable
        public HybridTimestamp get() {
            return null;
        }

        @Override
        public void update(@Nullable HybridTimestamp ts) {
        }
    };

    public static HybridTimestampTracker emptyTracker() {
        return EMPTY_TS_PROVIDER;
    }

    public static HybridTimestampTracker atomicTracker(final @Nullable HybridTimestamp intTs) {
        return new HybridTimestampTracker(){
            private final AtomicLong timestamp;
            {
                this.timestamp = new AtomicLong(HybridTimestamp.hybridTimestampToLong(intTs));
            }

            @Override
            @Nullable
            public HybridTimestamp get() {
                return HybridTimestamp.nullableHybridTimestamp(this.timestamp.get());
            }

            @Override
            public void update(@Nullable HybridTimestamp ts) {
                long tsVal = HybridTimestamp.hybridTimestampToLong(ts);
                this.timestamp.updateAndGet(x -> Math.max(x, tsVal));
            }
        };
    }

    public static HybridTimestampTracker clientTracker(final @Nullable HybridTimestamp intTs, final Consumer<HybridTimestamp> updateTs) {
        return new HybridTimestampTracker(){

            @Override
            @Nullable
            public HybridTimestamp get() {
                return intTs;
            }

            @Override
            public void update(@Nullable HybridTimestamp ts) {
                updateTs.accept(ts);
            }
        };
    }

    @Nullable
    public HybridTimestamp get();

    public void update(@Nullable HybridTimestamp var1);
}

