/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.type;

import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.type.NativeTypeSpec;

public class NativeType
implements Comparable<NativeType> {
    private final NativeTypeSpec typeSpec;
    private final int size;

    protected NativeType(NativeTypeSpec typeSpec, int size) {
        if (!typeSpec.fixedLength()) {
            throw new IllegalArgumentException("Size must be provided only for fixed-length types: " + String.valueOf((Object)typeSpec));
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive [typeSpec=" + String.valueOf((Object)typeSpec) + ", size=" + size + "]");
        }
        this.typeSpec = typeSpec;
        this.size = size;
    }

    protected NativeType(NativeTypeSpec typeSpec) {
        if (typeSpec.fixedLength()) {
            throw new IllegalArgumentException("Fixed-length types must be created by the length-aware constructor: " + String.valueOf((Object)typeSpec));
        }
        this.typeSpec = typeSpec;
        this.size = 0;
    }

    public int sizeInBytes() {
        return this.size;
    }

    public NativeTypeSpec spec() {
        return this.typeSpec;
    }

    public boolean mismatch(NativeType type) {
        return this != type && this.typeSpec != type.typeSpec;
    }

    public String displayName() {
        return this.typeSpec.asColumnType().name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeType that = (NativeType)o;
        return this.size == that.size && this.typeSpec == that.typeSpec;
    }

    public int hashCode() {
        int res = this.typeSpec.hashCode();
        res = 31 * res + this.size;
        return res;
    }

    @Override
    public int compareTo(NativeType o) {
        if (this.size <= 0 && o.size > 0) {
            return 1;
        }
        if (this.size > 0 && o.size <= 0) {
            return -1;
        }
        int cmp = Integer.compare(this.size, o.size);
        if (cmp != 0) {
            return cmp;
        }
        return this.typeSpec.name().compareTo(o.typeSpec.name());
    }

    public String toString() {
        return S.toString(NativeType.class.getSimpleName(), "name", (Object)this.typeSpec.name(), "sizeInBytes", (Object)this.size, "fixed", (Object)this.typeSpec.fixedLength());
    }
}

