/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.filters;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.context.ServerRequestContext;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
class ClientServerRequestTracingPublisher
implements Publishers.MicronautPublisher<HttpResponse<?>> {
    private final HttpRequest<?> request;
    private final Publisher<? extends HttpResponse<?>> actual;

    public ClientServerRequestTracingPublisher(HttpRequest<?> request, Publisher<? extends HttpResponse<?>> actual) {
        this.request = request;
        this.actual = actual;
    }

    public void subscribe(final Subscriber<? super HttpResponse<?>> subscriber) {
        ServerRequestContext.with(this.request, () -> this.actual.subscribe(new Subscriber<HttpResponse<?>>(){

            public void onSubscribe(Subscription s) {
                ServerRequestContext.with((HttpRequest)ClientServerRequestTracingPublisher.this.request, () -> subscriber.onSubscribe(s));
            }

            public void onNext(HttpResponse<?> mutableHttpResponse) {
                ServerRequestContext.with((HttpRequest)ClientServerRequestTracingPublisher.this.request, () -> subscriber.onNext((Object)mutableHttpResponse));
            }

            public void onError(Throwable t) {
                ServerRequestContext.with((HttpRequest)ClientServerRequestTracingPublisher.this.request, () -> subscriber.onError(t));
            }

            public void onComplete() {
                ServerRequestContext.with((HttpRequest)ClientServerRequestTracingPublisher.this.request, () -> ((Subscriber)subscriber).onComplete());
            }
        }));
    }
}

