/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.replication.GetEstimatedSizeRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.GetEstimatedSizeRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.GetEstimatedSizeRequestSerializer;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class GetEstimatedSizeRequestImpl
implements GetEstimatedSizeRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 25;
    @IgniteToStringInclude
    private final Long enlistmentConsistencyToken;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;

    private GetEstimatedSizeRequestImpl(Long enlistmentConsistencyToken, ReplicationGroupIdMessage groupId) {
        this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        this.groupId = groupId;
    }

    public Long enlistmentConsistencyToken() {
        return this.enlistmentConsistencyToken;
    }

    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    public MessageSerializer serializer() {
        return GetEstimatedSizeRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(GetEstimatedSizeRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 25;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetEstimatedSizeRequestImpl otherMessage = (GetEstimatedSizeRequestImpl)other;
        return Objects.equals(this.enlistmentConsistencyToken, otherMessage.enlistmentConsistencyToken) && Objects.equals(this.groupId, otherMessage.groupId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.enlistmentConsistencyToken, this.groupId);
        return result;
    }

    public GetEstimatedSizeRequestImpl clone() {
        try {
            return (GetEstimatedSizeRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GetEstimatedSizeRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements GetEstimatedSizeRequestBuilder {
        private Long enlistmentConsistencyToken;
        private ReplicationGroupIdMessage groupId;

        private Builder() {
        }

        @Override
        public GetEstimatedSizeRequestBuilder enlistmentConsistencyToken(Long enlistmentConsistencyToken) {
            Objects.requireNonNull(enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable");
            this.enlistmentConsistencyToken = enlistmentConsistencyToken;
            return this;
        }

        @Override
        public GetEstimatedSizeRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public Long enlistmentConsistencyToken() {
            return this.enlistmentConsistencyToken;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public GetEstimatedSizeRequest build() {
            return new GetEstimatedSizeRequestImpl(Objects.requireNonNull(this.enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable"), Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"));
        }
    }
}

