/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class NodeValue<T> {
    private final T value;
    private final boolean leaf;

    private NodeValue(T filter, boolean leaf) {
        this.value = Preconditions.checkNotNull(filter);
        this.leaf = leaf;
    }

    public static <T> NodeValue<T> of(T filter, boolean leaf) {
        return new NodeValue<T>(filter, leaf);
    }

    public T getValue() {
        return this.value;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public int hashCode() {
        return 31 * this.value.hashCode() + Boolean.valueOf(this.leaf).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeValue)) {
            return false;
        }
        NodeValue other = (NodeValue)o;
        return this.leaf == other.leaf && this.value.equals(other.value);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

