/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.compute;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.shaded.org.apache.ignite.compute.task.MapReduceTask;
import org.apache.ignite.shaded.org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.shaded.org.apache.ignite.marshalling.Marshaller;

public class TaskDescriptor<T, R> {
    private final String taskClassName;
    private final List<DeploymentUnit> units;
    private final Marshaller<T, byte[]> splitJobArgumentMarshaller;
    private final Marshaller<R, byte[]> reduceJobResultMarshaller;
    private final Class<R> reduceJobResultClass;

    private TaskDescriptor(String taskClassName, List<DeploymentUnit> units, Marshaller<T, byte[]> splitJobArgumentMarshaller, Marshaller<R, byte[]> reduceJobResultMarshaller, Class<R> reduceJobResultClass) {
        this.taskClassName = taskClassName;
        this.units = units;
        this.splitJobArgumentMarshaller = splitJobArgumentMarshaller;
        this.reduceJobResultMarshaller = reduceJobResultMarshaller;
        this.reduceJobResultClass = reduceJobResultClass;
    }

    public String taskClassName() {
        return this.taskClassName;
    }

    public List<DeploymentUnit> units() {
        return this.units;
    }

    public Marshaller<T, byte[]> splitJobArgumentMarshaller() {
        return this.splitJobArgumentMarshaller;
    }

    public Marshaller<R, byte[]> reduceJobResultMarshaller() {
        return this.reduceJobResultMarshaller;
    }

    public Class<R> reduceJobResultClass() {
        return this.reduceJobResultClass;
    }

    public static <T, R> Builder<T, R> builder(String taskClassName) {
        Objects.requireNonNull(taskClassName);
        return new Builder(taskClassName);
    }

    public static <I, M, T, R> Builder<I, R> builder(Class<? extends MapReduceTask<I, M, T, R>> taskClass) {
        Objects.requireNonNull(taskClass);
        return new Builder(taskClass.getName());
    }

    public static class Builder<T, R> {
        private final String taskClassName;
        private List<DeploymentUnit> units;
        private Marshaller<T, byte[]> splitJobArgumentMarshaller;
        private Marshaller<R, byte[]> reduceJobResultMarshaller;
        private Class<R> reduceJobResultClass;

        private Builder(String taskClassName) {
            Objects.requireNonNull(taskClassName);
            this.taskClassName = taskClassName;
        }

        public Builder<T, R> units(List<DeploymentUnit> units) {
            this.units = units;
            return this;
        }

        public Builder<T, R> units(DeploymentUnit ... units) {
            this.units = List.of(units);
            return this;
        }

        public Builder<T, R> splitJobArgumentMarshaller(Marshaller<T, byte[]> splitJobArgumentMarshaller) {
            this.splitJobArgumentMarshaller = splitJobArgumentMarshaller;
            return this;
        }

        public Builder<T, R> reduceJobResultMarshaller(Marshaller<R, byte[]> reduceJobResultMarshaller) {
            this.reduceJobResultMarshaller = reduceJobResultMarshaller;
            return this;
        }

        public Builder<T, R> reduceJobResultClass(Class<R> reduceJobResultClass) {
            this.reduceJobResultClass = reduceJobResultClass;
            return this;
        }

        public TaskDescriptor<T, R> build() {
            return new TaskDescriptor<T, R>(this.taskClassName, this.units == null ? List.of() : this.units, this.splitJobArgumentMarshaller, this.reduceJobResultMarshaller, this.reduceJobResultClass);
        }
    }
}

