/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.marshaller;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.apache.ignite.shaded.org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.shaded.org.apache.ignite.internal.marshaller.MarshallerColumn;
import org.apache.ignite.shaded.org.apache.ignite.internal.marshaller.MarshallerSchema;
import org.apache.ignite.shaded.org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.shaded.org.apache.ignite.table.mapper.Mapper;

public class ReflectionMarshallersProvider
implements MarshallersProvider {
    private static final int KV_CACHE_SIZE = 64;
    private static final int PROJECTION_CACHE_SIZE = 64;
    private final MarshallerCache marshallerCache = new MarshallerCache(64);
    private final MarshallerCache projectionMarshallerCache = new MarshallerCache(64);

    @Override
    public Marshaller getKeysMarshaller(MarshallerSchema schema, Mapper<?> mapper, boolean requireAllFields, boolean allowUnmappedFields) {
        MarshallerCacheKey key = new MarshallerCacheKey(schema.schemaVersion(), MarshallerType.KEY_ONLY, schema.keys(), mapper, requireAllFields, allowUnmappedFields);
        return this.marshallerCache.getOrAdd(key, k -> Marshaller.createMarshaller(schema.keys(), key.mapper, key.requireAllFields, key.allowUnmappedFields));
    }

    @Override
    public Marshaller getValuesMarshaller(MarshallerSchema schema, Mapper<?> mapper, boolean requireAllFields, boolean allowUnmappedFields) {
        MarshallerCacheKey key = new MarshallerCacheKey(schema.schemaVersion(), MarshallerType.VALUE_ONLY, schema.values(), mapper, requireAllFields, allowUnmappedFields);
        return this.marshallerCache.getOrAdd(key, k -> Marshaller.createMarshaller(schema.values(), key.mapper, key.requireAllFields, key.allowUnmappedFields));
    }

    @Override
    public Marshaller getRowMarshaller(MarshallerSchema schema, Mapper<?> mapper, boolean requireAllFields, boolean allowUnmappedFields) {
        MarshallerCacheKey key = new MarshallerCacheKey(schema.schemaVersion(), MarshallerType.FULL_ROW, schema.row(), mapper, requireAllFields, allowUnmappedFields);
        return this.marshallerCache.getOrAdd(key, k -> Marshaller.createMarshaller(schema.row(), key.mapper, key.requireAllFields, key.allowUnmappedFields));
    }

    @Override
    public Marshaller getMarshaller(MarshallerColumn[] columns, Mapper<?> mapper, boolean requireAllFields, boolean allowUnmappedFields) {
        MarshallerCacheKey key = new MarshallerCacheKey(columns, mapper, requireAllFields, allowUnmappedFields);
        return this.projectionMarshallerCache.getOrAdd(key, k -> Marshaller.createMarshaller(k.columns, k.mapper, k.requireAllFields, k.allowUnmappedFields));
    }

    private static class MarshallerCache {
        private final Cache<MarshallerCacheKey, Marshaller> cache;

        MarshallerCache(int maximumSize) {
            this.cache = Caffeine.newBuilder().maximumSize(maximumSize).build();
        }

        Marshaller getOrAdd(MarshallerCacheKey key, Function<MarshallerCacheKey, Marshaller> func) {
            return this.cache.get(key, func);
        }
    }

    private static final class MarshallerCacheKey {
        private final int schemaVersion;
        private final Mapper<?> mapper;
        private final MarshallerColumn[] columns;
        private final MarshallerType type;
        private final boolean requireAllFields;
        private final boolean allowUnmappedFields;

        MarshallerCacheKey(int schemaVersion, MarshallerType type, MarshallerColumn[] columns, Mapper<?> mapper, boolean requireAllFields, boolean allowUnmappedFields) {
            this.schemaVersion = schemaVersion;
            this.columns = columns;
            this.type = type;
            this.mapper = mapper;
            this.requireAllFields = requireAllFields;
            this.allowUnmappedFields = allowUnmappedFields;
        }

        MarshallerCacheKey(MarshallerColumn[] columns, Mapper<?> mapper, boolean requireAllFields, boolean allowUnmappedFields) {
            this.schemaVersion = -1;
            this.columns = columns;
            this.mapper = mapper;
            this.type = null;
            this.requireAllFields = requireAllFields;
            this.allowUnmappedFields = allowUnmappedFields;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MarshallerCacheKey that = (MarshallerCacheKey)o;
            return this.schemaVersion == that.schemaVersion && this.requireAllFields == that.requireAllFields && this.allowUnmappedFields == that.allowUnmappedFields && Objects.equals(this.mapper, that.mapper) && Arrays.equals(this.columns, that.columns) && this.type == that.type;
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.schemaVersion, this.mapper, this.type, this.requireAllFields, this.allowUnmappedFields});
            result = 31 * result + Arrays.hashCode(this.columns);
            return result;
        }
    }

    private static enum MarshallerType {
        KEY_ONLY,
        VALUE_ONLY,
        FULL_ROW;

    }
}

