/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.ThinClientConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class ClientConnectorConfiguration {
    public static final int DFLT_PORT = 10800;
    public static final int DFLT_PORT_RANGE = 100;
    public static final int DFLT_SOCK_BUF_SIZE = 0;
    public static final boolean DFLT_TCP_NO_DELAY = true;
    public static final int DFLT_MAX_OPEN_CURSORS_PER_CONN = 128;
    public static final int DFLT_THREAD_POOL_SIZE = IgniteConfiguration.DFLT_PUBLIC_THREAD_CNT;
    public static final int DFLT_SELECTOR_CNT = Math.max(4, Runtime.getRuntime().availableProcessors() / 2);
    public static final int DFLT_HANDSHAKE_TIMEOUT = 10000;
    public static final int DFLT_IDLE_TIMEOUT = 0;
    public static final boolean DFLT_USE_IGNITE_SSL_CTX_FACTORY = true;
    private String host;
    private int port = 10800;
    private int portRange = 100;
    private int sockSndBufSize = 0;
    private int sockRcvBufSize = 0;
    private boolean tcpNoDelay = true;
    private int maxOpenCursorsPerConn = 128;
    private int threadPoolSize = DFLT_THREAD_POOL_SIZE;
    private int selectorCnt = DFLT_SELECTOR_CNT;
    private long idleTimeout = 0L;
    private long handshakeTimeout = 10000L;
    private boolean jdbcEnabled = true;
    private boolean odbcEnabled = true;
    private boolean thinCliEnabled = true;
    private boolean sslEnabled;
    private boolean useIgniteSslCtxFactory = true;
    private boolean sslClientAuth;
    private Factory<SSLContext> sslCtxFactory;
    private ThinClientConfiguration thinCliCfg = new ThinClientConfiguration();

    public ClientConnectorConfiguration() {
    }

    public ClientConnectorConfiguration(ClientConnectorConfiguration cfg) {
        assert (cfg != null);
        this.host = cfg.getHost();
        this.maxOpenCursorsPerConn = cfg.getMaxOpenCursorsPerConnection();
        this.port = cfg.getPort();
        this.portRange = cfg.getPortRange();
        this.sockRcvBufSize = cfg.getSocketReceiveBufferSize();
        this.sockSndBufSize = cfg.getSocketSendBufferSize();
        this.tcpNoDelay = cfg.isTcpNoDelay();
        this.threadPoolSize = cfg.getThreadPoolSize();
        this.idleTimeout = cfg.getIdleTimeout();
        this.handshakeTimeout = cfg.getHandshakeTimeout();
        this.jdbcEnabled = cfg.jdbcEnabled;
        this.odbcEnabled = cfg.odbcEnabled;
        this.thinCliEnabled = cfg.thinCliEnabled;
        this.sslEnabled = cfg.isSslEnabled();
        this.sslClientAuth = cfg.isSslClientAuth();
        this.useIgniteSslCtxFactory = cfg.isUseIgniteSslContextFactory();
        this.sslCtxFactory = cfg.getSslContextFactory();
        this.thinCliCfg = new ThinClientConfiguration(cfg.getThinClientConfiguration());
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public ClientConnectorConfiguration setHost(@Nullable String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ClientConnectorConfiguration setPort(int port) {
        this.port = port;
        return this;
    }

    public int getPortRange() {
        return this.portRange;
    }

    public ClientConnectorConfiguration setPortRange(int portRange) {
        this.portRange = portRange;
        return this;
    }

    public int getSocketSendBufferSize() {
        return this.sockSndBufSize;
    }

    public ClientConnectorConfiguration setSocketSendBufferSize(int sockSndBufSize) {
        this.sockSndBufSize = sockSndBufSize;
        return this;
    }

    public int getSocketReceiveBufferSize() {
        return this.sockRcvBufSize;
    }

    public ClientConnectorConfiguration setSocketReceiveBufferSize(int sockRcvBufSize) {
        this.sockRcvBufSize = sockRcvBufSize;
        return this;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public ClientConnectorConfiguration setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public int getMaxOpenCursorsPerConnection() {
        return this.maxOpenCursorsPerConn;
    }

    public ClientConnectorConfiguration setMaxOpenCursorsPerConnection(int maxOpenCursorsPerConn) {
        this.maxOpenCursorsPerConn = maxOpenCursorsPerConn;
        return this;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public ClientConnectorConfiguration setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        return this;
    }

    public int getSelectorCount() {
        return this.selectorCnt;
    }

    public ClientConnectorConfiguration setSelectorCount(int selectorCnt) {
        this.selectorCnt = selectorCnt;
        return this;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public ClientConnectorConfiguration setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public long getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public ClientConnectorConfiguration setHandshakeTimeout(long handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    public boolean isJdbcEnabled() {
        return this.jdbcEnabled;
    }

    public ClientConnectorConfiguration setJdbcEnabled(boolean jdbcEnabled) {
        this.jdbcEnabled = jdbcEnabled;
        return this;
    }

    public boolean isOdbcEnabled() {
        return this.odbcEnabled;
    }

    public ClientConnectorConfiguration setOdbcEnabled(boolean odbcEnabled) {
        this.odbcEnabled = odbcEnabled;
        return this;
    }

    public boolean isThinClientEnabled() {
        return this.thinCliEnabled;
    }

    public ClientConnectorConfiguration setThinClientEnabled(boolean thinCliEnabled) {
        this.thinCliEnabled = thinCliEnabled;
        return this;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public ClientConnectorConfiguration setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    public boolean isUseIgniteSslContextFactory() {
        return this.useIgniteSslCtxFactory;
    }

    public ClientConnectorConfiguration setUseIgniteSslContextFactory(boolean useIgniteSslCtxFactory) {
        this.useIgniteSslCtxFactory = useIgniteSslCtxFactory;
        return this;
    }

    public boolean isSslClientAuth() {
        return this.sslClientAuth;
    }

    public ClientConnectorConfiguration setSslClientAuth(boolean sslClientAuth) {
        this.sslClientAuth = sslClientAuth;
        return this;
    }

    public ClientConnectorConfiguration setSslContextFactory(Factory<SSLContext> sslCtxFactory) {
        this.sslCtxFactory = sslCtxFactory;
        return this;
    }

    public Factory<SSLContext> getSslContextFactory() {
        return this.sslCtxFactory;
    }

    public ThinClientConfiguration getThinClientConfiguration() {
        return this.thinCliCfg;
    }

    public ClientConnectorConfiguration setThinClientConfiguration(ThinClientConfiguration thinCliCfg) {
        this.thinCliCfg = thinCliCfg;
        return this;
    }

    public String toString() {
        return S.toString(ClientConnectorConfiguration.class, this);
    }
}

