/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgniteDhtPartitionHistorySuppliersMap
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final IgniteDhtPartitionHistorySuppliersMap EMPTY = new IgniteDhtPartitionHistorySuppliersMap();
    private Map<UUID, Map<T2<Integer, Integer>, Long>> map;

    public static IgniteDhtPartitionHistorySuppliersMap empty() {
        return EMPTY;
    }

    public synchronized List<UUID> getSupplier(int grpId, int partId, long cntrSince) {
        if (this.map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<UUID> suppliers = new ArrayList<UUID>();
        for (Map.Entry<UUID, Map<T2<Integer, Integer>, Long>> e : this.map.entrySet()) {
            UUID supplierNode = e.getKey();
            Long historyCounter = e.getValue().get(new T2<Integer, Integer>(grpId, partId));
            if (historyCounter == null || historyCounter > cntrSince) continue;
            suppliers.add(supplierNode);
        }
        return suppliers;
    }

    @Nullable
    public synchronized Map<T2<Integer, Integer>, Long> getReservations(UUID nodeId) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(nodeId);
    }

    public synchronized void put(UUID nodeId, int grpId, int partId, long cntr) {
        Map<T2<Integer, Integer>, Long> nodeMap;
        if (this.map == null) {
            this.map = new HashMap<UUID, Map<T2<Integer, Integer>, Long>>();
        }
        if ((nodeMap = this.map.get(nodeId)) == null) {
            nodeMap = new HashMap<T2<Integer, Integer>, Long>();
            this.map.put(nodeId, nodeMap);
        }
        nodeMap.put(new T2<Integer, Integer>(grpId, partId), cntr);
    }

    public synchronized boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public synchronized void putAll(IgniteDhtPartitionHistorySuppliersMap that) {
        this.map = that.map;
    }

    public String toString() {
        return S.toString(IgniteDhtPartitionHistorySuppliersMap.class, this);
    }
}

