/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.mvcc.data;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.tree.AbstractDataInnerIO;

public final class MvccCacheIdAwareDataInnerIO
extends AbstractDataInnerIO {
    public static final IOVersions<MvccCacheIdAwareDataInnerIO> VERSIONS = new IOVersions((PageIO[])new MvccCacheIdAwareDataInnerIO[]{new MvccCacheIdAwareDataInnerIO(1)});

    private MvccCacheIdAwareDataInnerIO(int ver) {
        super(26, ver, true, 36);
    }

    @Override
    protected boolean storeCacheId() {
        return true;
    }

    @Override
    protected boolean storeMvccVersion() {
        return true;
    }

    @Override
    public int getCacheId(long pageAddr, int idx) {
        return PageUtils.getInt(pageAddr, this.offset(idx) + 12);
    }

    @Override
    public long getMvccCoordinatorVersion(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 16);
    }

    @Override
    public long getMvccCounter(long pageAddr, int idx) {
        return PageUtils.getLong(pageAddr, this.offset(idx) + 24);
    }

    @Override
    public int getMvccOperationCounter(long pageAddr, int idx) {
        return PageUtils.getInt(pageAddr, this.offset(idx) + 32);
    }
}

