/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.memory;

import java.util.Collection;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class MemoryMetricsCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.DATA_STORAGE_METRICS, GridRestCommand.DATA_REGION_METRICS);

    public MemoryMetricsCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        assert (req != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling " + req.command().key() + " REST request: " + req);
        }
        GridRestCommand cmd = req.command();
        switch (cmd) {
            case DATA_REGION_METRICS: {
                return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(this.ctx.grid().dataRegionMetrics()));
            }
            case DATA_STORAGE_METRICS: {
                if (this.ctx.config().getDataStorageConfiguration().isMetricsEnabled()) {
                    return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(this.ctx.grid().dataStorageMetrics()));
                }
                return new GridFinishedFuture<GridRestResponse>(new GridRestResponse("Storage metrics are not enabled"));
            }
        }
        return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(1, "Unknown command"));
    }
}

