/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheNamesCollectorTaskResult;
import org.apache.ignite.lang.IgniteUuid;

@GridInternal
public class VisorCacheNamesCollectorTask
extends VisorOneNodeTask<Void, VisorCacheNamesCollectorTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheNamesCollectorJob job(Void arg) {
        return new VisorCacheNamesCollectorJob(arg, this.debug);
    }

    private static class VisorCacheNamesCollectorJob
    extends VisorJob<Void, VisorCacheNamesCollectorTaskResult> {
        private static final long serialVersionUID = 0L;

        private VisorCacheNamesCollectorJob(Void arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorCacheNamesCollectorTaskResult run(Void arg) {
            GridCacheProcessor cacheProc = this.ignite.context().cache();
            HashMap<String, IgniteUuid> caches = new HashMap<String, IgniteUuid>();
            HashSet<String> groups = new HashSet<String>();
            for (Map.Entry<String, DynamicCacheDescriptor> item : cacheProc.cacheDescriptors().entrySet()) {
                DynamicCacheDescriptor cd = item.getValue();
                caches.put(item.getKey(), cd.deploymentId());
                String grp = cd.groupDescriptor().groupName();
                if (F.isEmpty(grp)) continue;
                groups.add(grp);
            }
            return new VisorCacheNamesCollectorTaskResult(caches, groups);
        }

        public String toString() {
            return S.toString(VisorCacheNamesCollectorJob.class, this);
        }
    }
}

