/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.node.VisorBinaryTypeConfiguration;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

public class VisorBinaryConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String idMapper;
    private String nameMapper;
    private String serializer;
    private List<VisorBinaryTypeConfiguration> typeCfgs;
    private boolean compactFooter;

    public VisorBinaryConfiguration() {
    }

    public VisorBinaryConfiguration(BinaryConfiguration src) {
        this.idMapper = VisorTaskUtils.compactClass(src.getIdMapper());
        this.nameMapper = VisorTaskUtils.compactClass(src.getNameMapper());
        this.serializer = VisorTaskUtils.compactClass(src.getSerializer());
        this.compactFooter = src.isCompactFooter();
        this.typeCfgs = VisorBinaryTypeConfiguration.list(src.getTypeConfigurations());
    }

    public String getIdMapper() {
        return this.idMapper;
    }

    public String getNameMapper() {
        return this.nameMapper;
    }

    public String getSerializer() {
        return this.serializer;
    }

    public List<VisorBinaryTypeConfiguration> getTypeConfigurations() {
        return this.typeCfgs;
    }

    public boolean isCompactFooter() {
        return this.compactFooter;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.idMapper);
        U.writeString(out, this.nameMapper);
        U.writeString(out, this.serializer);
        U.writeCollection(out, this.typeCfgs);
        out.writeBoolean(this.compactFooter);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.idMapper = U.readString(in);
        this.nameMapper = U.readString(in);
        this.serializer = U.readString(in);
        this.typeCfgs = U.readList(in);
        this.compactFooter = in.readBoolean();
    }

    public String toString() {
        return S.toString(VisorBinaryConfiguration.class, this);
    }
}

