/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.regex.Pattern;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;
import org.apache.ignite.lang.IgniteBiPredicate;

public class VisorQueryScanRegexFilter
implements IgniteBiPredicate<Object, Object> {
    private static final long serialVersionUID = 0L;
    private final Pattern ptrn;

    public VisorQueryScanRegexFilter(boolean caseSensitive, boolean regex, String ptrn) {
        int flags = caseSensitive ? 0 : 2;
        this.ptrn = Pattern.compile(regex ? ptrn : ".*?" + Pattern.quote(ptrn) + ".*?", flags);
    }

    @Override
    public boolean apply(Object key, Object val) {
        String k = key instanceof BinaryObject ? VisorQueryUtils.binaryToString((BinaryObject)key) : key.toString();
        String v = val instanceof BinaryObject ? VisorQueryUtils.binaryToString((BinaryObject)val) : val.toString();
        return this.ptrn.matcher(k).find() || this.ptrn.matcher(v).find();
    }
}

